
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Text label configurations
title = "Bus Stop Distribution in the City"
xlabel = "Longitude"
ylabel = "Latitude"

# Generate data for bus stops in a city
np.random.seed(42)
num_bus_stops = 250

# Simulate a grid-like pattern with some randomness
x = np.random.uniform(-10, 10, num_bus_stops) + np.random.normal(0, 0.5, num_bus_stops)
y = np.random.uniform(-10, 10, num_bus_stops) + np.random.normal(0, 0.5, num_bus_stops)

distances_from_center = np.sqrt(x**2 + y**2)

# Normalize these distances for color mapping
normalized_distances_from_center = (
    distances_from_center - np.min(distances_from_center)
) / (np.max(distances_from_center) - np.min(distances_from_center))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating a custom linear color map from yellow to deep blue based on distances
colors = [plt.cm.jet(1 - distance) for distance in normalized_distances_from_center]

# Set the figure size
plt.figure(figsize=(6, 6))

# Plot the points
plt.scatter(x, y, c=colors, s=50 + 200 * (1 - normalized_distances_from_center), edgecolor="none")

# Set the aspect of the plot to be equal
plt.axis("equal")

# Add axis lines and light grid lines for better visualization
plt.axhline(0, color="gray", linewidth=0.5, linestyle='--')
plt.axvline(0, color="gray", linewidth=0.5, linestyle='--')
plt.grid(color='gray', linestyle=':', linewidth=0.5)

# Add title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Add tick labels
plt.xticks([])
plt.yticks([])

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_39.pdf", bbox_inches="tight")
