

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import Normalize

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for Mood Index and Stress Impact
time = np.linspace(0, 24, 15)  # Time in hours
stress_level = np.linspace(0, 100, 15)  # Stress Level in percentage
Time, Stress = np.meshgrid(time, stress_level)
mood_index = np.sin(Time / 24 * 2 * np.pi) * np.exp(-Stress / 100)
stress_impact = np.cos(Time / 24 * 2 * np.pi) * np.exp(-Stress / 50)
Z = mood_index + stress_impact
dashed_line = time * 2  # Representative function for dashed line (e.g., stress level = 2*hour)
xlabel = r"Time (hours)"
ylabel = r"Stress Level (%)"
label = "Mood Index + Stress Impact (Scaled Units)"
title = "Mood Index and Stress Impact Over Time and Stress Levels"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create a heatmap
norm = Normalize(vmin=np.min(Z), vmax=np.max(Z))
cmap = plt.get_cmap("coolwarm")
heatmap = ax.imshow(Z, aspect="auto", cmap=cmap, norm=norm, extent=[0, 24, 0, 100], origin="lower")

# Add a colorbar
cbar = plt.colorbar(heatmap, ax=ax, label=label)
cbar.ax.tick_params(labelsize=10)

# Add a dashed line (approximation)
ax.plot(time, dashed_line, "b--", linewidth=2)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)

# Add grid for better readability
ax.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("HR_41.pdf", bbox_inches="tight")

