

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import Normalize

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample business data
departments = np.linspace(1, 5, 10)  # Number of departments
quarters = np.linspace(1, 4, 10)     # Quarters
Departments, Quarters = np.meshgrid(departments, quarters)
profit_margin = (Departments.max() - Departments) / Departments.max() * 0.5 + (Quarters / Quarters.max()) * 0.5
revenue = Departments * Quarters

# Reverse the order for better readability (optional)
new_profit_margin = []
for line in profit_margin:
    new_profit_margin.append(line[::-1])

dashed_line = departments * 1.3  # Adjusted function for dashed line (e.g., revenue target line)
xlabel = "Departments"
ylabel = "Quarters"
label = "Profit Margin"
title = "Revenue and Profit Margin"
subtitle = "Across different departments and quarters"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Create a heatmap
norm = Normalize(vmin=np.min(profit_margin), vmax=np.max(profit_margin))
cmap = plt.get_cmap("viridis")
heatmap = ax.imshow(
    new_profit_margin, aspect="auto", cmap=cmap, norm=norm, extent=[0, 5, 0, 7], origin="lower"
)

# Add a colorbar
cbar = plt.colorbar(heatmap, ax=ax, label=label)
cbar.ax.tick_params(labelsize=10)

# Add a dashed line (e.g., revenue target)
ax.plot(departments, dashed_line, "r--", linewidth=2)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(f"{title}\n{subtitle}", fontsize=16, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and display the plot
plt.tight_layout()
plt.savefig("HR_42.pdf", bbox_inches="tight")

