

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generating data for weather parameters over time (days of a year)
days = np.linspace(0, 365, 100)
temperature = 15 + 10 * np.sin(2 * np.pi * days / 365)  # in degrees Celsius
humidity = 50 + 20 * np.sin(4 * np.pi * days / 365)     # in percentage
wind_speed = 5 + 3 * np.sin(2 * np.pi * days / 365 + np.pi / 4)  # in m/s
precipitation = 2 + 1.5 * np.sin(2 * np.pi * days / 365 - np.pi / 3)  # in mm
solar_radiation = 300 + 100 * np.sin(2 * np.pi * days / 365)  # in W/m^2

# Generating data for temperature distribution among different regions
North = np.random.rand(2, 17) * 30
South = np.random.rand(4, 17) * 30
East = np.random.rand(5, 17) * 30
West = np.random.rand(4, 17) * 30
Central = np.random.rand(2, 17) * 30
North = [sorted(n1, reverse=True) for n1 in North]
South = [sorted(s1, reverse=True) for s1 in South]
East = [sorted(e1) for e1 in East]
West = [sorted(w1) for w1 in West]
Central = [sorted(c1) for c1 in Central]

xlabel = "Days of the Year"
ylabel = "Weather Parameter"
title = "Weather Parameters Over the Year"
baseline = 0
labels = ["North Region", "South Region", "East Region", "West Region", "Central Region"]
textheight = 20
xlabel2 = "Regions"
ylabel2 = "Temperature Distribution"
title2 = "Temperature Distribution Among Different Regions"
plotlabels = ["Temperature", "Humidity", "Wind Speed", "Precipitation", "Solar Radiation"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
colors = ["#8c564b", "#1f77b4", "#2ca02c", "#d62728", "#9467bd"]
plt.figure(figsize=(10, 7))

# Create the left plot (Weather parameters over time)
plt.subplot(1, 2, 1)
plt.plot(days, temperature, label=plotlabels[0], color=colors[0], linestyle='-', linewidth=2)
plt.plot(days, humidity, label=plotlabels[1], color=colors[1], linestyle='--', linewidth=2)
plt.plot(days, wind_speed, label=plotlabels[2], color=colors[2], linestyle='-.', linewidth=2)
plt.plot(days, precipitation, label=plotlabels[3], color=colors[3], linestyle=':', linewidth=2)
plt.plot(days, solar_radiation, label=plotlabels[4], color=colors[4], linestyle='-', linewidth=1)

plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(loc='upper center', bbox_to_anchor=(0.5, 1.2), ncol=2, fancybox=True, shadow=True)
plt.grid(True, linestyle='--', alpha=0.7)

# Create the right plot (Temperature distribution among regions)
plt.subplot(1, 2, 2)

for index, values in enumerate([North, South, East, West, Central]):
    for i in range(len(values)):
        plt.scatter(
            [baseline + i] * len(values[i]),
            range(len(values[i])),
            s=values[i],
            c=colors[index],
        )
    plt.text(baseline + len(values) / 2, textheight, labels[index], ha='center', fontsize=8)
    baseline = baseline + len(values)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

plt.xticks([])
plt.yticks([])
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.title(title2, y=1.05)
plt.gca().set_facecolor('#f7f7f7')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("HR_44.pdf", bbox_inches="tight")
