
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the parallelogram boundary points for a hypothetical stadium layout
boundary_points = np.array([[0, 0], [5, -1], [4, 5], [-1, 6]])

# Define the data for each subplot
data1 = np.random.rand(100000, 2)  # Soccer Fans
data1[:, 0] = data1[:, 0] * 5  # Scale x component from 0 to 5
data2 = np.random.rand(1000, 2)  # Basketball Fans
data3 = np.random.rand(1000, 2)  # Baseball Fans
data3[:, 0] = data3[:, 0] + 2

ylabel = [
    "Soccer Fans",
    "Basketball Fans",
    "Baseball Fans",
]
xlabel = "Sections in Stadium"
labels = ["North Stand", "East Stand", "South Stand", "West Stand"]  # Section labels
xlim = [-2, 6]
ylim = [-2, 7]
legendtitle = "num. of points = {}"
title = "Distribution of Sports Fans in Stadium"
supertitle = "Sports Fan Distribution"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define the figure size
fig = plt.figure(figsize=(12, 6))

# Color Variables
boundary_color = "lightgreen"
boundary_alpha = 0.3
scatter_color = "darkblue"
text_color = "darkred"
boundary_line_color = "darkgreen"

# Create subplots
for i, data in enumerate([data1, data2, data3], 1):
    ax = fig.add_subplot(1, 3, i)
    # Fill the parallelogram
    ax.fill(boundary_points[:, 0], boundary_points[:, 1], color=boundary_color, alpha=boundary_alpha)
    ax.set_xlim(xlim)  
    ax.set_ylim(ylim)  
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel[i - 1])
    if i != 1:
        ax.set_yticks([])

    for point, label in zip(boundary_points, labels):
        if point[0] < 2:
            ax.text(point[0] - 0.8, point[1] - 0.3, label, color=text_color, fontsize=10)
        else:
            ax.text(point[0], point[1] + 0.2, label, color=text_color, fontsize=10)
    scatter = ax.scatter(data[:, 0], data[:, 1], color=scatter_color, s=2, marker='o')
    ax.legend([scatter], [legendtitle.format(100000 if i == 1 else 1000)], loc="upper right")
    ax.plot(
        np.append(boundary_points[:, 0], boundary_points[0, 0]),
        np.append(boundary_points[:, 1], boundary_points[0, 1]),
        color=boundary_line_color, linestyle='--', linewidth=1.5
    )

# Add titles
fig.suptitle(supertitle, fontsize=16)
fig.subplots_adjust(top=0.85)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("HR_48.pdf", bbox_inches="tight")
