
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # New seed for different random data

# Define the parallelogram boundary points
boundary_points = np.array([[90, 60], [130, 80], [120, 100], [70, 85]])

# Define the data for each subplot
# Simulate blood pressure readings (systolic, diastolic)
data1 = np.random.randn(100000, 2) * [5, 3] + [120, 80]  # Normal readings
data2 = np.random.randn(1000, 2) * [10, 5] + [140, 90]   # Elevated readings
data3 = np.random.randn(1000, 2) * [12, 7] + [160, 100]  # Hypertension readings

# New labels and text relevant to health data
ylabel = [
    "Patient Group A - Blood Pressure",
    "Patient Group B - Blood Pressure",
    "Patient Group C - Blood Pressure",
]
xlabel = "Time of Day"
labels = ["Morning", "Afternoon", "Evening", "Night"]
xlim = [85, 165]
ylim = [55, 105]
legendtitle = "Samples count = {}"
supertitle = "Blood Pressure Analysis of Different Patient Groups Throughout the Day"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Define the figure size
fig = plt.figure(figsize=(12, 6))
fig.suptitle(supertitle, fontsize=14)

# Create subplots
for i, data in enumerate([data1, data2, data3], 1):
    ax = fig.add_subplot(1, 3, i)
    # Fill the parallelogram
    ax.fill(boundary_points[:, 0], boundary_points[:, 1], color="lightgreen", alpha=0.5)
    ax.set_xlim(xlim)  # Adjusted x limits to better fit the parallelogram
    ax.set_ylim(ylim)  # Adjusted y limits to better fit the parallelogram
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel[i - 1])
    if i != 1:
        ax.set_yticks([])

    for point, label in zip(boundary_points, labels):
        ax.text(point[0], point[1], label, color="darkblue", fontsize=10, ha='center')

    scatter = ax.scatter(data[:, 0], data[:, 1], color="darkred", s=1, marker='o')
    ax.legend([scatter], [legendtitle.format(len(data))], loc="upper left")
    ax.plot(
        np.append(boundary_points[:, 0], boundary_points[0, 0]),
        np.append(boundary_points[:, 1], boundary_points[0, 1]),
        color="darkgreen", linestyle='--', linewidth=1.5
    )

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust layout to make space for the supertitle
plt.savefig("HR_49.pdf", bbox_inches="tight")
