

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
num_points = 1000
t = np.linspace(0, 4*np.pi, num_points)
candidate_a = 50 + 10 * np.sin(t)
candidate_b = 55 + 12 * np.sin(t + np.pi/4)
candidate_c = 52 + 15 * np.sin(t + np.pi/2)

# Labels and titles
xlabel = "Time (weeks)"
ylabel = "Popularity of Candidate A"
zlabel = "Popularity of Candidate B"
title = "Popularity Trends of Three Political Candidates"
label_helix = "Popularity Path"
annotation_text = "Start of Tracking"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 6))
ax = fig.add_subplot(projection='3d')

# Color gradient
colors = plt.cm.plasma(np.linspace(0, 1, num_points))

for i in range(num_points-1):
    ax.plot(t[i:i+2], candidate_a[i:i+2], candidate_b[i:i+2], color=colors[i], linewidth=2)

# Mark the starting point
ax.scatter(t[0], candidate_a[0], candidate_b[0], color='black', s=50, label=annotation_text)

# Title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)

# Legend
ax.legend()

# Additional adjustments: Grid, Aspect ratio
ax.grid(True)
ax.set_box_aspect([2, 2, 1])  # Aspect ratio for the 3D plot

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_54.pdf", bbox_inches="tight")

