
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set random seed for reproducibility
np.random.seed(0)

# Generate time values
num_points = 3000
time = np.linspace(0, 10, num_points)  # Time span of 10 years

# Generate political interest values with a sinusoidal function superimposed on a linear growth
interest_level = 5 + 2 * np.sin(2 * np.pi * time) + 0.5 * time  # Baseline + fluctuations + growth

# Convert to Cartesian coordinates (for illustrative purposes)
x = time
y = interest_level

# Labels and titles
label = "Political Interest Over Time"
title = "Fluctuations in Political Interest Over Time"
xlabel = "Time (Years)"
ylabel = "Interest Level"
legendlabels = ["Political Interest"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 10))
line_color = "#1f78b4"  # Blue
marker_color = "ro"  # Red for the start marker

plt.plot(x, y, label=legendlabels[0], linestyle='-', color=line_color, linewidth=1.5)  # Blue line for political interest
plt.plot(x[0], y[0], marker_color)  # Red marker at the start
plt.title(title, fontsize=16, fontweight='bold')
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.axis("equal")
plt.gca().set_aspect("equal", adjustable="box")
plt.legend()
plt.grid(True, linestyle='--', alpha=0.7)  # Adding grid for better readability
plt.gca().set_facecolor('#f0f0f0')  # Light grey background

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_55.pdf", bbox_inches="tight")
