

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # For reproducibility

# Data representing marketing spend vs. revenue generated for different regions
marketing_spend = [10, 200]
revenue_generated = [5000, 120000]

# Points (regions: North America, Europe, Asia, South America, Africa, Oceania)
points_x = [20, 50, 80, 40, 10, 15]
points_y = [25000, 60000, 95000, 36000, 12000, 18000]
labels = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Oceania",
]

markers = ["o", "s", "D", "v", "^", "p"]
axlines = [
    [[10, 250], [25000, 25000]],
    [[5, 250], [5000, 5000]],
    [[15, 250], [120000, 120000]],
]
x_fill = [10, 200, 250, 250]
y_fill_top = [5000, 120000, 120000, 120000]
y_fill_bottom = [2000, 2000, 2000, 2000]
xlabel = "Marketing Spend (in thousand dollars)"
ylabel = "Revenue Generated (in thousand dollars)"
xlim = [10, 250]
ylim = [2000, 150000]
textlabels = ["Minimum Revenue", "Peak Revenue", "Optimal Spending Range"]
textposition = [[20, 7500], [150, 125000], [150, 65000]]
title="Revenue Generated vs. Marketing Spend"
suptitle="A Comparison Across Different Regions"
legendtitle="Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))
colors = ["forestgreen", "dodgerblue", "goldenrod", "firebrick", "mediumorchid", "brown"]
# Plot the revenue model
ax.plot(marketing_spend, revenue_generated, color="black", linestyle="--", linewidth=2)

# Adding horizontal revenue lines
for line in axlines:
    ax.plot(line[0], line[1], color="grey", linestyle=":")

ax.fill_between(x_fill, y_fill_top, y_fill_bottom, color="lightgreen", alpha=0.3)

# Add text annotations
for pos, label in zip(textposition, textlabels):
    ax.text(
        pos[0], pos[1], label, rotation=0, verticalalignment="bottom", horizontalalignment="center", fontsize=10
    )

# Plot the points
for x, y, label, color, marker in zip(points_x, points_y, labels, colors, markers):
    ax.plot(x, y, label=label, color=color, marker=marker, markersize=10)

# Set scale to log
ax.set_xscale("log")
ax.set_yscale("log")

# Set labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Set limits
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# Add legend
ax.legend(title=legendtitle, loc="lower left", fontsize=10)

# Add title and subtitle
plt.title(title, fontsize=14)
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(pad=2)
plt.savefig("HR_56.pdf", bbox_inches="tight")

