
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib_venn import venn2

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Create a Venn diagram
venn = venn2(subsets=(40, 35, 20), set_labels=("Renewable Energy", "Climate Change"))

# Update titles and labels
title = "Overlap Between Interests in Renewable Energy and Climate Change"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customize the colors and edge styles
venn.get_patch_by_id("10").set_color("skyblue")
venn.get_patch_by_id("10").set_edgecolor("black")
venn.get_patch_by_id("10").set_linestyle("solid")
venn.get_patch_by_id("01").set_color("lightcoral")
venn.get_patch_by_id("01").set_edgecolor("black")
venn.get_patch_by_id("01").set_linestyle("solid")
venn.get_patch_by_id("11").set_color("mediumpurple")

# Add title
plt.title(title)

# Remove axis
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_62.pdf", bbox_inches="tight")
