
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Placeholder economic data: GDP growth rates across years for different countries
years = np.linspace(2010, 2020, 10)  # From 2010 to 2020

# Simulate GDP growth rates for 10 countries
gdp_country_A = np.sin(0.2 * years) + np.random.normal(0, 0.5, 10) + 2
gdp_country_B = np.cos(0.2 * years) + np.random.normal(0, 0.5, 10) + 2
gdp_country_C = np.sin(0.2 * years - 1) + np.random.normal(0, 0.5, 10) + 2
gdp_country_D = np.cos(0.2 * years - 1) + np.random.normal(0, 0.5, 10) + 2

# Create error bands
gdp_A_err = gdp_country_A * 0.1
gdp_B_err = gdp_country_B * 0.1
gdp_C_err = gdp_country_C * 0.15
gdp_D_err = gdp_country_D * 0.15

xlabel = "Years"
ylabels = [
    "Average GDP Growth Rate (Country A & B)",
    "Average GDP Growth Rate (Country C & D)"
]
xlim = [2009, 2021]
ylim = [-1, 5]
title =["GDP Growth Rate: Country A & B", "GDP Growth Rate: Country C & D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified size (width, height)
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plot data and curves for the left subplot (Country A & B)
ax1.plot(years, gdp_country_A, "o", color="blue", label="Country A")
ax1.fill_between(years, gdp_country_A - gdp_A_err, gdp_country_A + gdp_A_err, color="blue", alpha=0.2)
coeffs = np.polyfit(years, gdp_country_A, 2)
fit_func = np.poly1d(coeffs)
ax1.plot(years, fit_func(years), "-", color="darkblue")

ax1.plot(years, gdp_country_B, "s", color="green", label="Country B")
ax1.fill_between(years, gdp_country_B - gdp_B_err, gdp_country_B + gdp_B_err, color="green", alpha=0.2)
coeffs = np.polyfit(years, gdp_country_B, 2)
fit_func = np.poly1d(coeffs)
ax1.plot(years, fit_func(years), "-", color="darkgreen")

ax1.set_xlim(xlim)
ax1.set_ylim(ylim)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabels[0])
ax1.legend(frameon=True)
ax1.set_title(title[0])

# Plot data and curves for the right subplot (Country C & D)
ax2.plot(years, gdp_country_C, "o", color="orange", label="Country C")
ax2.fill_between(years, gdp_country_C - gdp_C_err, gdp_country_C + gdp_C_err, color="orange", alpha=0.2)
coeffs = np.polyfit(years, gdp_country_C, 2)
fit_func = np.poly1d(coeffs)
ax2.plot(years, fit_func(years), "-", color="darkorange")

ax2.plot(years, gdp_country_D, "s", color="red", label="Country D")
ax2.fill_between(years, gdp_country_D - gdp_D_err, gdp_country_D + gdp_D_err, color="red", alpha=0.2)
coeffs = np.polyfit(years, gdp_country_D, 2)
fit_func = np.poly1d(coeffs)
ax2.plot(years, fit_func(years), "-", color="darkred")

ax2.set_xlim(xlim)
ax2.set_ylim(ylim)
ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabels[1])
ax2.legend(frameon=True)
ax2.set_title(title[1])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("HR_68.pdf", bbox_inches="tight")
