
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Placeholder data for population indicators
years = np.linspace(2000, 2020, 10)
total_population = np.linspace(6, 8, 10) * 1e9  # Total population in billions
birth_rate = 20 - np.linspace(0, 5, 10)  # Birth rate per 1000 people
death_rate = 8 + np.linspace(0, 2, 10)  # Death rate per 1000 people

# Create error bands
total_population_err = total_population * 0.03
birth_rate_err = birth_rate * 0.1
death_rate_err = death_rate * 0.1

xlabel = "Year"
ylabel1 = "Total Population (Billions)"
ylabel2 = "Rate (per 1000 People)"
title1 = "Total Population Over Years"
title2 = "Birth and Death Rates Over Years"
legendlabels = ["Total Population", "Birth Rate", "Death Rate"]
filename = "HR_70_3.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes with specified size (width, height)
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Plot data and curves for the left subplot (Total Population)
ax1.plot(years, total_population, "o", color="blue", label=legendlabels[0])
ax1.fill_between(
    years,
    total_population - total_population_err,
    total_population + total_population_err,
    color="blue",
    alpha=0.2,
)
# Fit and plot a line
coeffs = np.polyfit(years, np.log(total_population), 2)
fit_func = np.poly1d(coeffs)
ax1.plot(years, np.exp(fit_func(years)), "k--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax1.set_title(title1)
ax1.legend(frameon=True)

# Plot data and curves for the right subplot (Birth and Death Rates)
ax2.plot(years, birth_rate, "s", color="green", label=legendlabels[1])
ax2.fill_between(
    years,
    birth_rate - birth_rate_err,
    birth_rate + birth_rate_err,
    color="green",
    alpha=0.2,
)
# Fit and plot a line
coeffs = np.polyfit(years, np.log(birth_rate), 2)
fit_func = np.poly1d(coeffs)
ax2.plot(years, np.exp(fit_func(years)), "k--")

ax2.plot(years, death_rate, "^", color="red", label=legendlabels[2])
ax2.fill_between(
    years,
    death_rate - death_rate_err,
    death_rate + death_rate_err,
    color="red",
    alpha=0.2,
)
# Fit and plot a line
coeffs = np.polyfit(years, np.log(death_rate), 2)
fit_func = np.poly1d(coeffs)
ax2.plot(years, np.exp(fit_func(years)), "k--")

ax2.set_xlabel(xlabel)
ax2.set_ylabel(ylabel2)
ax2.set_title(title2)
ax2.legend(frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("HR_70.pdf", bbox_inches="tight")
