
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data and labels
theta = [0.5, 1.2, 2.0, 4.0, 5.5]  # Angles for the bars
radii = np.array([30, 10, 50, 25, 35])  # Radii of the bars representing usage percentage
width = [0.7, 0.4, 1.2, 0.6, 0.8]  # Width of the bars
categories = [
    "Messaging Apps",
    "Emails",
    "Social Media",
    "Phone Calls",
    "In-Person Meetings",
]  # Labels for the bars

# Text parameters
title = "Usage of Different Communication Methods"
xlabel = "Communication Methods"
ylabel = "Usage (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ['#4CAF50', '#8BC34A', '#00BCD4', '#2196F3', '#3F51B5']  # Custom color palette

# Create the figure
plt.figure(figsize=(8, 8))
ax = plt.subplot(111, projection="polar")  # Set up polar plot

# Plot the bars
bars = ax.bar(theta, radii, width=width, bottom=0, color=colors, alpha=0.7, zorder=3)

# Add labels to the bars
for bar, angle, label in zip(bars, theta, categories):
    rotation = np.degrees(angle)  # Convert angle to degrees
    alignment = "center"  # Center align the labels
    # Place the text inside the bar, rotated correctly
    ax.text(
        angle,
        bar.get_height() + 0.5,
        label,
        ha=alignment,
        va="center",
        rotation_mode="anchor",
    )

# Remove the polar angle labels to declutter the plot
ax.set_xticklabels([])

# Remove the radial labels
ax.set_yticklabels([])

# Add title
plt.title(title, va='bottom')

# ===================
# Part 4: Saving Output
# ===================
# Save the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_72.pdf", bbox_inches="tight")
