
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seeding for reproducibility
np.random.seed(42)

def generate_viewer_distribution(x, platforms=3):
    """Generate random viewer distribution data for multiple streaming platforms."""
    
    def add_random_peaks(a):
        amplitude = 1 / (0.1 + np.random.random())
        dx = x[-1] - x[0]
        x0 = (2 * np.random.random() - 0.5) * dx
        z = 5 / (0.1 + np.random.random()) / dx
        a += amplitude * np.exp(-((z * (x - x0)) ** 2))
    
    a = np.zeros_like(x)
    for _ in range(platforms):
        add_random_peaks(a)
    return a

# Time (e.g., in months)
x = np.linspace(0, 24, 25)
# Viewer distribution on different platforms (Netflix, Hulu, Disney+)
ys = [generate_viewer_distribution(x) for _ in range(3)]

# Text label parameters
xlabel = 'Time (Months)'
ylabel = 'Viewer Count'
title = 'Viewer Distribution Over Time on Different Platforms'
legend_labels = ['Netflix', 'Hulu', 'Disney+']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Custom colors
colors = ['#1f77b4', '#ff7f0e', '#2ca02c']
# Create the stackplot
ax.stackplot(x, ys, baseline="wiggle", colors=colors)

# Setting labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(legend_labels, loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_74.pdf", bbox_inches="tight")
