

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Generating synthetic data for business domain
import numpy as np
np.random.seed(42)  # For reproducibility

# Data for four employees
broken_barh_datax1 = [(8, 12), (25, 20), (50, 10)]
broken_barh_datay1 = (10, 9)
broken_barh_datax2 = [(15, 15), (40, 15), (65, 20)]
broken_barh_datay2 = (10, 9)
broken_barh_datax3 = [(5, 25), (35, 10), (55, 25)]
broken_barh_datay3 = (30, 9)
broken_barh_datax4 = [(10, 20), (45, 15), (75, 15)]
broken_barh_datay4 = (30, 9)

# Labels and other chart parameters
labels = ["Sales Calls", "Meetings", "Paperwork", "Breaks"]
datalabels = ["Employee John", "Employee Jane"]
yticks = [15, 35]
ylim = [5, 45]
xlim = [0, 100]
xlabel = "Minutes Across the Workday"
annotations = "Important Client Call"
annotatestart = (30, 35)
annotateend = (0.1, 0.9)
title = "Daily Activity Distribution in a Business Environment"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define new colors for the business domain
facecolors = ["#a6cee3", "#b2df8a", "#fb9a99", "#fdbf6f"]

fig, ax = plt.subplots(figsize=(8, 6))

ax.broken_barh(
    broken_barh_datax1, broken_barh_datay1, facecolors=facecolors[0], label=labels[0]
)
ax.broken_barh(
    broken_barh_datax2, broken_barh_datay2, facecolors=facecolors[1], label=labels[1]
)
ax.broken_barh(
    broken_barh_datax3, broken_barh_datay3, facecolors=facecolors[2], label=labels[2]
)
ax.broken_barh(
    broken_barh_datax4, broken_barh_datay4, facecolors=facecolors[3], label=labels[3]
)

ax.set_ylim(ylim)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_yticks(yticks)
ax.set_yticklabels(datalabels)  # More descriptive labels
ax.grid(True)  # Make grid lines visible
ax.annotate(
    annotations,
    annotatestart,
    xytext=annotateend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=12,
    horizontalalignment="right",
    verticalalignment="top",
)

# Title and legend
ax.set_title(title)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_87.pdf", bbox_inches="tight")

