
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new dummy data for the environmental science domain
urban_aqi_days = [
    45,
    60,
    80,
    100,
    75,
    60,
    40,
    30,
    20,
    10,
    5,
]  # Urban Areas
rural_aqi_days = [
    50,
    70,
    90,
    110,
    85,
    70,
    50,
    40,
    30,
    20,
    15,
]  # Rural Areas
bins = [0, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500]
labels = ["Urban Areas", "Rural Areas"]
xlabel = "AQI Range"
xlim = [-10, 510]
ylim = [0, 400]
ylabel = "Number of Days"
xticks = [0, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500]
yticks = [0, 50, 100, 150, 200, 250, 300, 350, 400]
left, bottom, width, height = [0.2, 0.53, 0.3, 0.3]
insetxlim = [0, 250]
insetxticks = [0, 50, 100, 150, 200, 250]
insetylim = [0, 220]
insetyticks = [0, 40, 80, 120, 160, 200, 240]
mainpointleft = [50, 45]
mainpointright = [250, 40]
insetleft = [0, 0]
insetright = [250, 0]

# Text labels
suptitle = "Comparison of AQI in Urban and Rural Areas"
title = "AQI Distribution by Location Type"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 45  # Slightly less than the bin width to create a gap

ax_main.bar(
    bins,
    urban_aqi_days,
    width=bar_width,
    color="orange",
    align="center",
    label=labels[0],
    edgecolor="white",
    alpha=0.8
)
ax_main.bar(
    bins,
    rural_aqi_days,
    width=bar_width,
    color="steelblue",
    align="center",
    bottom=urban_aqi_days,
    label=labels[1],
    edgecolor="white",
    alpha=0.8
)
ax_main.set_xlabel(xlabel)
ax_main.set_xlim(xlim)
ax_main.set_xticks(xticks)
ax_main.set_ylabel(ylabel)
ax_main.set_ylim(ylim)
ax_main.set_yticks(yticks)
ax_main.legend(loc="upper right", prop={"size": 14})
ax_main.grid(True)

# Create inset plot with adjusted bar widths and white borders

ax_inset = fig.add_axes([left, bottom, width, height])
ax_inset.bar(
    bins[:6],
    urban_aqi_days[:6],
    width=bar_width,
    color="orange",
    align="center",
    edgecolor="white",
    alpha=0.8
)
ax_inset.bar(
    bins[:6],
    rural_aqi_days[:6],
    width=bar_width,
    color="steelblue",
    align="center",
    bottom=urban_aqi_days[:6],
    edgecolor="white",
    alpha=0.8
)
ax_inset.set_xlim(insetxlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(insetxticks)  # Zoom in on the right part of the data
ax_inset.set_ylim(insetylim)
ax_inset.set_yticks(insetyticks)
ax_inset.grid(True)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainpointleft)
main_plot_right = ax_main.transData.transform_point(mainpointright)

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(insetleft)
inset_right = ax_inset.transData.transform_point(insetright)

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], inset_left[1]),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], inset_right[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle(suptitle, fontsize=16)
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("PIP_26.pdf", bbox_inches="tight")
