

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
quarters = ["Q1", "Q2", "Q3", "Q4"]
action_ratings = [7.8, 8.1, 7.5, 8.0]
comedy_ratings = [7.0, 6.8, 7.2, 7.5]
drama_ratings = [8.5, 8.7, 8.3, 8.6]
scifi_ratings = [7.9, 8.2, 7.8, 8.4]
labels = ["Action", "Comedy", "Drama", "Sci-Fi"]

# Inset parameters
insertax1 = [0.3, 0.2, 0.1, 0.3]
insertylim1 = [7, 9]
insertxlim1 = [0.5, 1.5]
insertax2 = [0.8, 0.2, 0.1, 0.3]
insertylim2 = [6.5, 9]
insertxlim2 = [2.5, 3.5]

# Text labels
xlabel = "Quarters"
ylabel = "Average Rating"
title = "Average Movie Ratings by Genre and Quarter"
insetaxes = [0.3, 0.2, 0.1, 0.3]
arrowend1 = [0.3, 0.4]
arrowend2 = [0.8, 0.2]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

ax.plot(quarters, action_ratings, color="#1f77b4", linestyle='-', marker='o', markersize=10, label=labels[0])
ax.plot(quarters, comedy_ratings, color="#ff7f0e", linestyle='--', marker='s', markersize=10, label=labels[1])
ax.plot(quarters, drama_ratings, color="#2ca02c", linestyle='-.', marker='^', markersize=10, label=labels[2])
ax.plot(quarters, scifi_ratings, color="#d62728", linestyle=':', marker='D', markersize=10, label=labels[3])

# Create the inset with the zoomed-in view
ax_inset1 = fig.add_axes(insertax1)
ax_inset1.plot(quarters, action_ratings, color="#1f77b4", linestyle='-', marker='o')
ax_inset1.plot(quarters, comedy_ratings, color="#ff7f0e", linestyle='--', marker='s')
ax_inset1.plot(quarters, drama_ratings, color="#2ca02c", linestyle='-.', marker='^')
ax_inset1.plot(quarters, scifi_ratings, color="#d62728", linestyle=':', marker='D')
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")
ax_inset1.set_ylim(insertylim1)
ax_inset1.set_xlim(insertxlim1)

# Create the inset with the zoomed-in view
ax_inset2 = fig.add_axes(insertax2)
ax_inset2.plot(quarters, action_ratings, color="#1f77b4", linestyle='-', marker='o')
ax_inset2.plot(quarters, comedy_ratings, color="#ff7f0e", linestyle='--', marker='s')
ax_inset2.plot(quarters, drama_ratings, color="#2ca02c", linestyle='-.', marker='^')
ax_inset2.plot(quarters, scifi_ratings, color="#d62728", linestyle=':', marker='D')
ax_inset2.spines["bottom"].set_color("black")
ax_inset2.spines["left"].set_color("black")
ax_inset2.spines["top"].set_color("black")
ax_inset2.spines["right"].set_color("black")
ax_inset2.set_ylim(insertylim2)
ax_inset2.set_xlim(insertxlim2)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)

# Annotate with arrows
ax.annotate(
    "",
    xy=(quarters[1], scifi_ratings[1]),
    xytext=arrowend1,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)
ax.annotate(
    "",
    xy=(quarters[3], scifi_ratings[3]),
    xytext=arrowend2,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1, shrink=0.01),
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_27.pdf", bbox_inches="tight")

