
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Simulated Data for Seasonal Temperatures in Different Cities
seasons = ["Spring", "Summer", "Fall", "Winter"]
num_seasons = len(seasons)
x = np.arange(1, num_seasons + 1)
city_a = np.array([15.0, 25.0, 20.0, 5.0])
city_b = np.array([18.0, 30.0, 22.0, 8.0])
city_c = np.array([12.0, 22.0, 18.0, 2.0])
city_d = np.array([16.0, 28.0, 24.0, 10.0])

labels = ["City A", "City B", "City C", "City D"]
xlabel = "Seasons"
ylabel = "Average Temperature (°C)"
xlim = [0.5, 4.5]
ylim = [0, 35]
yticks = [0, 5, 10, 15, 20, 25, 30, 35]
insetaxes = [0.45, 0.2, 0.25, 0.25]
yinsetlim = [0, 25]
xticklabels = seasons
insetxticklabels = ["Fall", "Winter"]
yinsetyticks = [5, 10, 15, 20, 25]
title = "Seasonal Average Temperatures in Different Cities"
legendlabels = ["City A", "City B", "City C", "City D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data
ax.plot(x, city_a, "o-", label=labels[0], color="#FF6F61")  # Warm orange
ax.plot(x, city_b, "x-", label=labels[1], color="#6B5B95")  # Deep purple
ax.plot(x, city_c, "s-", label=labels[2], color="#88B04B")  # Olive green
ax.plot(x, city_d, "d-", label=labels[3], color="#2A9D8F")  # Teal

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust x-axis and y-axis limits
ax.set_xlim(xlim)
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a legend
ax.legend(title='Cities', loc='upper left')

# Create an inset axis for more detailed data
ax_inset = fig.add_axes(insetaxes)
ax_inset.plot(x, city_c, "s-", color="#88B04B")  # Olive green
ax_inset.plot(x, city_d, "d-", color="#2A9D8F")  # Teal

# Adjust y-axis limits for inset
ax_inset.set_ylim(yinsetlim)

# Set the same x-axis limits for the inset as the main plot
ax_inset.set_xlim([2.5,4.5])
ax_inset.set_yticks(yinsetyticks)

# Change x-axis tick labels to seasonal notation
ax.set_xticks(x)
ax.set_xticklabels(xticklabels)
ax_inset.set_xticks(x[2:4])
ax_inset.set_xticklabels(insetxticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_33.pdf", bbox_inches="tight")
