

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to simulate speed trends for different athletes over training weeks
x = np.linspace(0, 52, 100)  # Representing weeks of a year
y1 = 25 + 5 * np.sin(x) + np.random.normal(0, 1, 100)  # Athlete A
y2 = 27 + 5 * np.sin(x + 0.5) + np.random.normal(0, 1, 100)  # Athlete B
y3 = 29 + 5 * np.sin(x + 1.0) + np.random.normal(0, 1, 100)  # Athlete C
y4 = 31 + 5 * np.sin(x + 1.5) + np.random.normal(0, 1, 100)  # Athlete D

# Labels and Plot Types
label_athlete_a = "Athlete A"
label_athlete_b = "Athlete B"
label_athlete_c = "Athlete C"
label_athlete_d = "Athlete D"

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Speed (km/h)"
zoomed_in_axes = [0.5, 0.70, 0.3, 0.20]
xlim_values = [40, 52]
ylim_values = [20, 40]
xticks_values = [40, 45, 50]
yticks_values = [20, 25, 30, 35]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the curves with enhanced styles
ax.plot(x, y1, "d-", color='#1f77b4', label=label_athlete_a, linewidth=2)
ax.plot(x, y2, "s--", color='#ff7f0e', label=label_athlete_b, linewidth=2)
ax.plot(x, y3, "^:", color='#2ca02c', label=label_athlete_c, linewidth=2)
ax.plot(x, y4, "o-.", color='#d62728', label=label_athlete_d, linewidth=2)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title('Average Speed Trends Over a Year')
ax.set_ylim(15,50)
# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(x, y1, "d-", color='#1f77b4')
ax_inset.plot(x, y2, "s--", color='#ff7f0e')
ax_inset.plot(x, y3, "^:", color='#2ca02c')
ax_inset.plot(x, y4, "o-.", color='#d62728')
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.grid(True, linestyle='--', alpha=0.7)  # Add grid lines for readability
ax_inset.spines["bottom"].set_color("black")  
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper left", bbox_to_anchor=(1, 1))

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_36.pdf", bbox_inches="tight")
