
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data: Simulated monthly stock price variations for four companies
months = np.linspace(1, 12, 100)
stock_company1 = 100 + 20 * np.sin(2 * np.pi * (months - 3) / 12) + 5 * np.random.randn(100)
stock_company2 = 120 + 15 * np.sin(2 * np.pi * (months - 4) / 12) + 5 * np.random.randn(100)
stock_company3 = 80 + 10 * np.sin(2 * np.pi * (months - 5) / 12) + 5 * np.random.randn(100)
stock_company4 = 110 + 25 * np.sin(2 * np.pi * (months - 2) / 12) + 5 * np.random.randn(100)

# Labels and Plot Types
label_company1 = "Company A"
label_company2 = "Company B"
label_company3 = "Company C"
label_company4 = "Company D"

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Stock Price ($)"
zoomed_in_axes = [0.5, 0.15, 0.25, 0.25]
xlim_values = [10, 12]
ylim_values = [70, 130]
xticks_values = [10, 11, 12]
yticks_values = [80, 100, 120]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the curves with custom colors and styles
color_company1 = "#1f77b4"
color_company2 = "#ff7f0e"
color_company3 = "#2ca02c"
color_company4 = "#d62728"

ax.plot(months, stock_company1, label=label_company1, color=color_company1, linestyle='-', marker='o')
ax.plot(months, stock_company2, label=label_company2, color=color_company2, linestyle='--', marker='s')
ax.plot(months, stock_company3, label=label_company3, color=color_company3, linestyle='-.', marker='^')
ax.plot(months, stock_company4, label=label_company4, color=color_company4, linestyle=':', marker='d')

# Set labels and title
ax.set_ylim(40,160)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(months, stock_company1, color=color_company1, linestyle='-', marker='o')
ax_inset.plot(months, stock_company2, color=color_company2, linestyle='--', marker='s')
ax_inset.plot(months, stock_company3, color=color_company3, linestyle='-.', marker='^')
ax_inset.plot(months, stock_company4, color=color_company4, linestyle=':', marker='d')
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_37.pdf", bbox_inches="tight")
