

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate synthetic monthly tourist data over 12 months
months = np.arange(1, 13)
tourist_site_A = 5000 + 1500 * np.sin(2 * np.pi * months / 12)  # Tourist Site A
tourist_site_B = 6000 + 1300 * np.cos(2 * np.pi * months / 12)  # Tourist Site B
tourist_site_C = 4500 + 1400 * np.sin(2 * np.pi * months / 12 + np.pi/6)  # Tourist Site C
tourist_site_D = 5500 + 1200 * np.cos(2 * np.pi * months / 12 + np.pi/6)  # Tourist Site D

# Labels and Plot Types
label_TouristSiteA = "Tourist Site A"
label_TouristSiteB = "Tourist Site B"
label_TouristSiteC = "Tourist Site C"
label_TouristSiteD = "Tourist Site D"

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value = "Number of Tourists"
zoomed_in_axes = [0.5, 0.7, 0.2, 0.2]
xlim_values = [9, 12]
ylim_values = [3500, 7000]
xticks_values = [10, 11, 12]
yticks_values = [4000, 5000, 6000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Custom color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot the curves with custom styles
ax.plot(months, tourist_site_A, color=colors[0], linestyle='-', linewidth=2, label=label_TouristSiteA)
ax.plot(months, tourist_site_B, color=colors[1], linestyle='--', linewidth=2, label=label_TouristSiteB)
ax.plot(months, tourist_site_C, color=colors[2], linestyle='-.', linewidth=2, label=label_TouristSiteC)
ax.plot(months, tourist_site_D, color=colors[3], linestyle=':', linewidth=2, label=label_TouristSiteD)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(zoomed_in_axes)
ax_inset.plot(months, tourist_site_A, color=colors[0], linestyle='-')
ax_inset.plot(months, tourist_site_B, color=colors[1], linestyle='--')
ax_inset.plot(months, tourist_site_C, color=colors[2], linestyle='-.')
ax_inset.plot(months, tourist_site_D, color=colors[3], linestyle=':')
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_38.pdf", bbox_inches="tight")

