
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to approximate stock prices over 200 days
days = np.linspace(1, 200, 200)
company1_prices = 50 + np.cumsum(np.random.normal(0, 1.5, 200))
company2_prices = 45 + np.cumsum(np.random.normal(0, 1.5, 200))

# Labels and titles
labels = ["Company 1", "Company 2"]
xlabel = "Days"
ylabel = "Stock Price (USD)"
title = "Daily Stock Price Trends"
insetxlim = [80, 90]
insetylim = [40, 60]
insetxticks = [80, 85, 90]
insetyticks = [40, 45, 50, 55, 60]
insetaxes = [0.7, 0.4, 0.20, 0.20]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(6, 4))
color_company1 = "#1f77b4"
color_company2 = "#2ca02c"

# Plot the curves
ax.plot(days, company1_prices, color_company1, linestyle='-', linewidth=1.5, marker='o', markersize=4, label=labels[0])
ax.plot(days, company2_prices, color_company2, linestyle='--', linewidth=1.5, marker='s', markersize=4, label=labels[1])

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim([0, 200])
ax.set_ylim([0, 100])

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(insetaxes)  # Adjust the position to align with the right side of the main plot
ax_inset.plot(days, company1_prices, color_company1, linestyle='-', linewidth=1.5, marker='o', markersize=4)
ax_inset.plot(days, company2_prices, color_company2, linestyle='--', linewidth=1.5, marker='s', markersize=4)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_41.pdf", bbox_inches="tight")
