
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate sample data for energy sources with adjusted positions and spread
x_renewable = np.random.normal(3, 0.8, 100)
y_renewable = np.random.normal(4, 0.8, 100)

x_non_renewable = np.random.normal(1, 1.2, 100)
y_non_renewable = np.random.normal(1.5, 1.2, 100)

x_nuclear = np.random.normal(2, 1, 100)
y_nuclear = np.random.normal(3, 1, 100)

# Labels and axis settings for the plot
xlabel = "Energy Availability"
ylabel = "Efficiency"
title = "Energy Source Efficiency Analysis"
supertitle = "Energy Sources"
legendlabels = ["Renewable Energy", "Non-Renewable Energy", "Nuclear Energy"]
insetxlim = [0, 2]
insetylim = [0, 2]
insetxticks = [0, 1, 2]
insetyticks = [0, 1, 2]
axesgrid = [0.65, 0.1, 0.2, 0.2]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the requirements
fig, ax = plt.subplots(figsize=(10, 8))

# Colors for different types of energy
color_renewable = "#8B4513"    # Sienna
color_non_renewable = "#1E90FF" # DodgerBlue
color_nuclear = "#32CD32"      # LimeGreen

# Plot the data with modified colors and markers
ax.scatter(x_renewable, y_renewable, c=color_renewable, label=legendlabels[0], marker='o')  # Sienna for Renewable
ax.scatter(x_non_renewable, y_non_renewable, c=color_non_renewable, label=legendlabels[1], marker='^')  # DodgerBlue for Non-Renewable
ax.scatter(x_nuclear, y_nuclear, c=color_nuclear, label=legendlabels[2], marker='s') # LimeGreen for Nuclear

# Add title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
fig.suptitle(supertitle, fontsize=16)

# Add the legend
ax.legend(legendlabels, loc="upper right", frameon=True)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(axesgrid)
ax_inset.scatter(x_renewable, y_renewable, c=color_renewable, marker='o')
ax_inset.scatter(x_non_renewable, y_non_renewable, c=color_non_renewable, marker='^')
ax_inset.scatter(x_nuclear, y_nuclear, c=color_nuclear, marker='s')
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")


# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_42.pdf", bbox_inches="tight")

