
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate sample data for three different regions and their transportation usage
urban_public_transport = np.random.normal(700, 150, 100)
urban_private_vehicles = np.random.normal(1200, 250, 100)
urban_bicycles = np.random.normal(300, 50, 100)

suburban_public_transport = np.random.normal(400, 100, 100)
suburban_private_vehicles = np.random.normal(900, 200, 100)
suburban_bicycles = np.random.normal(150, 30, 100)

rural_public_transport = np.random.normal(200, 50, 100)
rural_private_vehicles = np.random.normal(600, 150, 100)
rural_bicycles = np.random.normal(100, 20, 100)

# Labels and plot settings
labels = ["Urban", "Suburban", "Rural"]
xlabel = "Daily Users"
ylabel = "Average Daily Travel Distance (km)"
title = "Transportation Types vs Daily Usage"
insetxlim = [500, 800]
insetylim = [650, 950]
insetxticks = [600, 700, 800]
insetyticks = [650, 800, 950]
axesgrid = [0.65, 0.1, 0.2, 0.2]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 8))

# Plot the data with customized colors and markers
ax.scatter(urban_public_transport, urban_private_vehicles, c="#FF5733", marker='o', label=labels[0])
ax.scatter(suburban_public_transport, suburban_private_vehicles, c="#33FF57", marker='s', label=labels[1])
ax.scatter(rural_public_transport, rural_private_vehicles, c="#3357FF", marker='^', label=labels[2])

# Adding axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add the legend
ax.legend(loc="upper left", frameon=True)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(axesgrid)
ax_inset.scatter(urban_public_transport, urban_private_vehicles, c="#FF5733", marker='o', label=labels[0])
ax_inset.scatter(suburban_public_transport, suburban_private_vehicles, c="#33FF57", marker='s', label=labels[1])
ax_inset.scatter(rural_public_transport, rural_private_vehicles, c="#3357FF", marker='^', label=labels[2])
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("PIP_43.pdf", bbox_inches="tight")
