

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

clusters = {
    "Teens": np.random.normal(loc=(15, 4000), scale=[2, 500], size=(50, 2)),
    "Young Adults": np.random.normal(loc=(25, 5500), scale=[3, 800], size=(30, 2)),
    "Adults": np.random.normal(loc=(40, 7000), scale=[5, 1000], size=(40, 2)),
    "Middle Age": np.random.normal(loc=(50, 6500), scale=[4, 900], size=(60, 2)),
    "Seniors": np.random.normal(loc=(65, 5000), scale=[6, 600], size=(70, 2)),
    "Retired": np.random.normal(loc=(75, 4000), scale=[5, 700], size=(45, 2)),
}

# Labels and text properties
xlabel = "Age"
ylabel = "Annual Spending ($)"
title = "Market Segmentation by Customer Age Group"
legendlabels = {"Teens", "Young Adults", "Adults", "Middle Age", "Seniors", "Retired"}
insetaxes = [0.3, 0.2, 0.2, 0.2]
insetxlim = [10, 20]
insetylim = [3000, 5000]
insetxticks = [10, 15, 20]
insetyticks = [3000, 4000, 5000]
arrowstart = (40, 3000)
arrowend = (0.15, 0.2)
annotaterecx = [15, 20]
annotaterecy = [3000, 4500]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Colors for each cluster using a new color scheme
colors = {
    "Teens": "#1f77b4",     # muted blue
    "Young Adults": "#ff7f0e",  # safety orange
    "Adults": "#2ca02c",     # cooked asparagus green
    "Middle Age": "#d62728", # brick red
    "Seniors": "#9467bd",    # muted purple
    "Retired": "#8c564b",    # chestnut brown
}

for cluster, data in clusters.items():
    ax.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.6, label=cluster, edgecolors="w", s=100)

# Annotate main plot area
ax.plot([annotaterecx[0], annotaterecx[1]], [annotaterecy[1], annotaterecy[1]], color="black", lw=1)
ax.plot([annotaterecx[0], annotaterecx[1]], [annotaterecy[0], annotaterecy[0]], color="black", lw=1)
ax.plot([annotaterecx[0], annotaterecx[0]], [annotaterecy[0], annotaterecy[1]], color="black", lw=1)
ax.plot([annotaterecx[1], annotaterecx[1]], [annotaterecy[0], annotaterecy[1]], color="black", lw=1)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(insetaxes)
for cluster, data in clusters.items():
    ax_inset.scatter(data[:, 0], data[:, 1], c=colors[cluster], alpha=0.6, edgecolors="w", s=50)
ax_inset.set_xlim(insetxlim)
ax_inset.set_ylim(insetylim)
ax_inset.set_xticks(insetxticks)
ax_inset.set_yticks(insetyticks)
ax_inset.spines["bottom"].set_color("black")
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Adding annotation arrow
ax.annotate(
    "",
    xy=arrowstart,
    xytext=arrowend,
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.1),
)

# Set axis labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper right", bbox_to_anchor=(1.2, 1))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_47.pdf", bbox_inches="tight")

