

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Art and Design data for Art Piece Prices and Popularity Scores
import numpy as np

np.random.seed(42)
price_region_a = np.random.normal(150000, 25000, 10)
popularity_region_a = np.random.normal(7.5, 1.2, 10)
price_region_b = np.random.normal(90000, 20000, 10)
popularity_region_b = np.random.normal(5.0, 1.5, 10)
price_region_ab = np.concatenate([price_region_a, price_region_b])
popularity_region_ab = np.concatenate([popularity_region_a, popularity_region_b])

price_region_c = np.random.normal(170000, 30000, 5)
popularity_region_c = np.random.normal(8.0, 1.0, 5)
price_region_d = np.random.normal(110000, 18000, 5)
popularity_region_d = np.random.normal(6.0, 1.3, 5)

# Labels and plot limits
xlabel = "Art Piece Prices ($)"
ylabel = "Popularity Score"
title = "Art and Design Overview: Prices vs. Popularity"
ax1xlim = [50000, 200000]
ax1ylim = [3.0, 10.0]
main_diff_line = [[90000, 90000], [50000, 200000], [3.0, 10.0]]
inset_diff_line = [[90000, 90000], [60000, 150000], [4.0, 9.0]]
annotation_rect_x = [60000, 150000]
annotation_rect_y = [4.0, 9.0]
ax2xlim = [60000, 150000]
ax2ylim = [4.0, 9.0]
main_plot_upper = [60000, 9.0]
main_plot_lower = [60000, 4.0]

labels = ["Regions A & B", "Region C", "Region D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
# Scatter plots
ax1.scatter(
    price_region_ab, popularity_region_ab, marker="^", color="#2a9d8f", label=labels[0]
)
ax1.scatter(price_region_c, popularity_region_c, marker="o", color="#e76f51", label=labels[1])
ax1.scatter(price_region_d, popularity_region_d, marker="s", color="#f4a261", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[7.5, ax1ylim[1]], x1=ax1xlim[0], x2=90000, color="blue", alpha=0.2)
ax1.fill_betweenx(y=[7.5, ax1ylim[0]], x1=90000, x2=ax1xlim[1], color="yellow", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(main_diff_line[1], main_diff_line[0], color="black", lw=0.5)
ax1.plot(main_diff_line[0], main_diff_line[2], color="black", lw=0.5)

ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[1], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[0]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[0], annotation_rect_x[0]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)
ax1.plot(
    [annotation_rect_x[1], annotation_rect_x[1]],
    [annotation_rect_y[0], annotation_rect_y[1]],
    color="black",
    lw=0.5,
)

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)

# Scatter plots
ax2.scatter(price_region_ab, popularity_region_ab, marker="^", color="#2a9d8f")
ax2.scatter(price_region_c, popularity_region_c, marker="o", color="#e76f51")
ax2.scatter(price_region_d, popularity_region_d, marker="s", color="#f4a261")

# Shaded regions
ax2.fill_betweenx(y=[ax2ylim[1], 7.5], x1=ax2xlim[0], x2=90000, color="blue", alpha=0.2)
ax2.fill_betweenx(y=[7.5, ax2ylim[0]], x1=90000, x2=ax2xlim[1], color="yellow", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(inset_diff_line[1], inset_diff_line[0], color="black", lw=0.5)
ax2.plot(inset_diff_line[0], inset_diff_line[2], color="black", lw=0.5)
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(main_plot_upper)
ax1_plot_down = ax1.transData.transform_point(main_plot_lower)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(main_plot_upper)
ax2_down = ax2.transData.transform_point(main_plot_lower)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_54.pdf", bbox_inches="tight")

