
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Movie Genre Performance
np.random.seed(0)
x_action = np.random.normal(20, 5, 10)  # Increase in Popularity (Action)
y_action = np.random.normal(120, 20, 10)  # Revenue Generated (Action)

x_comedy = np.random.normal(15, 4, 10)  # Increase in Popularity (Comedy)
y_comedy = np.random.normal(100, 15, 10)  # Revenue Generated (Comedy)

x_drama = np.random.normal(25, 6, 10)  # Increase in Popularity (Drama)
y_drama = np.random.normal(150, 30, 10)  # Revenue Generated (Drama)

# Axis labels and limits
xlabel = "Increase in Popularity (%)"
ylabel = "Revenue Generated (million $)"
ax1xlim = [0, 40]
ax1ylim = [50, 200]
ax2xlim = [10, 30]
ax2ylim = [80, 170]
diffline1 = [[0, 0], [10, 30], [50, 200]]
diffline2 = [[0, 0], [10, 30], [80, 170]]
title1 = "Overall Movie Genre Performance"
title2 = "Zoom-in View"
label = ["Action", "Comedy", "Drama"]
plot_up1 = [10, 80]
plot_down1 = [10, 170]

labels = ["Action", "Comedy", "Drama"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(x_action, y_action, marker="o", color="#FF5733", label=labels[0])
ax1.scatter(x_comedy, y_comedy, marker="s", color="#33FF57", label=labels[1])
ax1.scatter(x_drama, y_drama, marker="^", color="#3357FF", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="#FFD700", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper left")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Rectangle on main plot
rect_main = Rectangle((10, 80), 20, 90, linewidth=1, edgecolor="black", facecolor="none")
ax1.add_patch(rect_main)

# Scatter plots for zoom-in view
ax2.scatter(x_action, y_action, marker="o", color="#FF5733", label=label[0])
ax2.scatter(x_comedy, y_comedy, marker="s", color="#33FF57", label=label[1])
ax2.scatter(x_drama, y_drama, marker="^", color="#3357FF", label=label[2])

# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=10, x2=ax2xlim[1], color="#FFD700", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_57.pdf", bbox_inches="tight")
