
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle

# ===================
# Part 2: Data Preparation
# ===================
# Sales Metrics
import numpy as np
np.random.seed(42)
x_customer_acquisition = np.random.normal(15, 3, 10)  # Customer Acquisition (Year 1)
y_customer_acquisition = np.random.normal(25, 5, 10)  # Customer Acquisition (Year 2)

x_revenue_growth = np.random.normal(20, 4, 10)  # Revenue Growth (Year 1)
y_revenue_growth = np.random.normal(35, 6, 10)  # Revenue Growth (Year 2)

x_market_share = np.random.normal(10, 2, 10)  # Market Share Increase (Year 1)
y_market_share = np.random.normal(15, 3, 10)  # Market Share Increase (Year 2)

# Axis labels and limits
xlabel = "Year 1 Improvement (%)"
ylabel = "Year 2 Improvement (%)"
ax1xlim = [5, 25]
ax1ylim = [10, 40]
ax2xlim = [10, 20]
ax2ylim = [20, 30]
diffline1 = [[0, 0], [5, 25], [10, 40]]
diffline2 = [[0, 0], [10, 20], [20, 30]]
title1 = "Sales Metrics Improvement"
title2 = "Zoom-in View"
label = ["Customer Acquisition", "Revenue Growth", "Market Share"]
plot_up1 = [10, 20]
plot_down1 = [10, 31]

labels = ["Customer Acquisition", "Revenue Growth", "Market Share"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(
    x_customer_acquisition, y_customer_acquisition, marker="o", color="#2ca02c", label=labels[0]
)
ax1.scatter(
    x_revenue_growth, y_revenue_growth, marker="s", color="#1f77b4", label=labels[1]
)
ax1.scatter(x_market_share, y_market_share, marker="^", color="#ff7f0e", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="#d0f0c0", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper left")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Scatter plots for zoom-in view
ax2.scatter(
    x_customer_acquisition, y_customer_acquisition, marker="o", color="#2ca02c", label=label[0]
)
ax2.scatter(
    x_revenue_growth, y_revenue_growth, marker="s", color="#1f77b4", label=label[1]
)
ax2.scatter(x_market_share, y_market_share, marker="^", color="#ff7f0e", label=label[2])

# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=0, x2=ax2xlim[1], color="#c6e2ff", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Rectangle on main plot
rect_main = Rectangle(
    (10, 20), 10, 12, linewidth=1, edgecolor="black", facecolor="none"
)
ax1.add_patch(rect_main)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_58.pdf", bbox_inches="tight")
