
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle

# ===================
# Part 2: Data Preparation
# ===================
# AI Algorithms
import numpy as np

np.random.seed(0)

# Compact EV Market Trends
x_compact_ev = np.random.normal(20, 5, 10)  # Market Share (%)
y_compact_ev = np.random.normal(70, 10, 10)  # User Satisfaction (Score)

# SUV Market Trends
x_suv_ev = np.random.normal(35, 7, 10)  # Market Share (%)
y_suv_ev = np.random.normal(80, 8, 10)  # User Satisfaction (Score)

# Luxury EV Market Trends
x_luxury_ev = np.random.normal(10, 4, 10)  # Market Share (%)
y_luxury_ev = np.random.normal(90, 5, 10)  # User Satisfaction (Score)

# Axis labels and limits
xlabel = "Market Share (%)"
ylabel = "User Satisfaction (Score)"
ax1xlim = [0, 50]
ax1ylim = [50, 100]
ax2xlim = [5, 35]
ax2ylim = [60, 90]
diffline1 = [[0, 0], [20, 70], [50, 80]]
diffline2 = [[0, 0], [20, 60], [35, 90]]
title1 = "Adoption of Electric Vehicle Types"
title2 = "Zoom-in View of Market Shares"
plot_up1 = [20, 60]
plot_down1 = [35, 90]

labels = ["Compact EV", "SUV EV", "Luxury EV"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Scatter plots
ax1.scatter(x_compact_ev, y_compact_ev, marker="o", color="orange", label=labels[0])
ax1.scatter(x_suv_ev, y_suv_ev, marker="s", color="blue", label=labels[1])
ax1.scatter(x_luxury_ev, y_luxury_ev, marker="^", color="green", label=labels[2])

# Shaded regions
ax1.fill_betweenx(y=[0, ax1ylim[1]], x1=0, x2=ax1xlim[1], color="lightgray", alpha=0.2)

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend(loc="upper right")
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.set_title(title1)

# Rectangle on main plot
rect_main = Rectangle((20, 60), 15, 30, linewidth=1, edgecolor="black", facecolor="none")
ax1.add_patch(rect_main)

# Scatter plots for zoom-in view
ax2.scatter(x_compact_ev, y_compact_ev, marker="o", color="orange", label=labels[0])
ax2.scatter(x_suv_ev, y_suv_ev, marker="s", color="blue", label=labels[1])
ax2.scatter(x_luxury_ev, y_luxury_ev, marker="^", color="green", label=labels[2])


# Shaded regions
ax2.fill_betweenx(y=[0, ax2ylim[1]], x1=4, x2=ax2xlim[1], color="lightgreen", alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)
ax2.set_title(title2)

# Coordinates of the main plot corners
# Coordinates of the inset corners
ax1_plot_up = ax1.transData.transform_point(plot_up1)
ax1_plot_down = ax1.transData.transform_point(plot_down1)
ax2_plot_up = ax2.transData.transform_point(plot_up1)
ax2_plot_down = ax2.transData.transform_point(plot_down1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_plot_up)
inset_down = fig.transFigure.inverted().transform(ax2_plot_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_59.pdf", bbox_inches="tight")
