
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample communication data (signal strength, noise level, data speed, and latency)
import numpy as np

np.random.seed(0)
channel_signal_A = np.random.normal(-50, 10, 10)  # Signal strength for Channel A
channel_signal_B = np.random.normal(-40, 15, 10)  # Signal strength for Channel B
channel_noise_A = np.random.normal(-80, 15, 10)  # Noise level for Channel A
channel_noise_B = np.random.normal(-70, 20, 10)  # Noise level for Channel B
signal_total = np.concatenate([channel_signal_A, channel_signal_B])
noise_total = np.concatenate([channel_noise_A, channel_noise_B])

speed_A = np.random.normal(100, 20, 5)  # Data speed for Channel A
speed_B = np.random.normal(150, 25, 5)  # Data speed for Channel B

latency_A = np.random.normal(20, 5, 5)  # Latency for Channel A
latency_B = np.random.normal(30, 7, 5)  # Latency for Channel B

xlabel = "Signal Strength (dB)"
ylabel = "Noise Level (dB)"
ax1xlim = [-100, 0]
ax1ylim = [-120, -20]
diffline1 = [[-100, -100], [0, -40], [-20, -70]]
diffline2 = [[-100, -100], [-50, -70], [-20, -90]]
annotaterecx1 = [-60, -40]
annotaterecy1 = [-80, -60]
ax2xlim = [-60, -40]
ax2ylim = [-80, -60]
plotup1 = [-60, -80]
plotdown1 = [-60, -60]

title = "Communication Data Analysis"
supertitle = "Signal and Noise Correlations Across Channels"
label = [
    "Channel A & B (Signal vs. Noise)",
    "Channel C (Data Speed)",
    "Channel D (Latency)",
]
label2 = ["High-Signal Zone", "Moderate-Signal Zone"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))
fig.suptitle(supertitle, fontsize=14)

# Scatter plots
ax1.scatter(
    signal_total, noise_total, marker="^", color="#FF6347", label=label[0]
)
ax1.scatter(speed_A, speed_B, marker="o", color="#4682B4", label=label[1])
ax1.scatter(latency_A, latency_B, marker="s", color="#2E8B57", label=label[2])

# # Shaded regions
# ax1.fill_betweenx(
#     y=[-120, 0], x1=-100, x2=0, color="#FF4500", alpha=0.2, label=label2[0]
# )
# ax1.fill_betweenx(
#     y=[-120, -20], x1=-100, x2=0, color="#98FB98", alpha=0.2, label=label2[1]
# )

# Axis limits and aspect ratio
ax1.set_xlim(ax1xlim)
ax1.set_ylim(ax1ylim)
ax1.plot(diffline1[1], diffline1[0], color="black", lw=1, linestyle="--")
ax1.plot(diffline1[0], diffline1[2], color="black", lw=1, linestyle="--")

ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[1], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[0]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[0], annotaterecx1[0]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)
ax1.plot(
    [annotaterecx1[1], annotaterecx1[1]],
    [annotaterecy1[0], annotaterecy1[1]],
    color="black",
    lw=1,
    linestyle="--",
)

ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.grid(True, which="both", linestyle="--", lw=0.5)
ax1.legend(loc="upper right")
ax1.set_title(title, fontsize=12)

# Scatter plots for the second axis
ax2.scatter(signal_total, noise_total, marker="^", color="#FF6347")
ax2.scatter(speed_A, speed_B, marker="o", color="#4682B4")
ax2.scatter(latency_A, latency_B, marker="s", color="#2E8B57")

# # Shaded regions
# ax2.fill_betweenx(y=[-60, -80], x1=-60, x2=0, alpha=0.2)
# ax2.fill_betweenx(y=[-60, -80], x1=0, x2=-40, alpha=0.2)

# Axis limits and aspect ratio
ax2.set_xlim(ax2xlim)
ax2.set_ylim(ax2ylim)
ax2.plot(diffline2[1], diffline2[0], color="black", lw=1, linestyle="--")
ax2.plot(diffline2[0], diffline2[2], color="black", lw=1, linestyle="--")
ax2.grid(True, which="both", linestyle="--", lw=0.5)

# Coordinates of the main plot corners
ax1_plot_up = ax1.transData.transform_point(plotup1)
ax1_plot_down = ax1.transData.transform_point(plotdown1)

# Coordinates of the inset corners
ax2_up = ax2.transData.transform_point(plotup1)
ax2_down = ax2.transData.transform_point(plotdown1)

# Transform to figure coordinates for annotation
main_plot_up = fig.transFigure.inverted().transform(ax1_plot_up)
main_plot_down = fig.transFigure.inverted().transform(ax1_plot_down)
inset_up = fig.transFigure.inverted().transform(ax2_up)
inset_down = fig.transFigure.inverted().transform(ax2_down)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_up[0], inset_up[0]), (main_plot_up[1], inset_up[1]), color="gray"
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_down[0], inset_down[0]),
        (main_plot_down[1], inset_down[1]),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_60.pdf", bbox_inches="tight")
