
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)
# Data
x = np.arange(1, 13)  # Months
y1 = np.random.uniform(5000, 15000, len(x))  # Product A sales
y2 = np.random.uniform(3000, 12000, len(x))  # Product B sales
labels = ["Product A", "Product B"]
xlabel = "Month"
ylabel = "Sales ($)"
title = "Monthly Sales Data for Products"
insetaxes = [0.4, 0.6, 0.2, 0.3]
insertax1 = [0.4, 0.6, 0.1, 0.3]
insertxlim1 = [4, 6]
insertylim1 = [6000, 8000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))

# Plot Data
ax.plot(x, y1, "r-*", label=labels[0])
ax.plot(x, y2, "b-v", label=labels[1])

# Create inset 1
ax_inset1 = fig.add_axes(insetaxes)
ax_inset1.plot(x, y1, "r-*")
ax_inset1.plot(x, y2, "b-v")
ax_inset1.set_xlim(insertxlim1)
ax_inset1.set_ylim(insertylim1)
ax_inset1.spines["bottom"].set_color("black")
ax_inset1.spines["left"].set_color("black")
ax_inset1.spines["top"].set_color("black")
ax_inset1.spines["right"].set_color("black")

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper left")
ax.grid(True)


ax.annotate(
    "",
    xy=(5, y2[4]),
    xytext=[0.4, 0.55],
    textcoords="axes fraction",
    arrowprops=dict(facecolor="black", lw=0.5, shrink=0.05),
)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("PIP_65.pdf", bbox_inches="tight")

