
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generate some economic data
gdp_growth_rates = [
    2.5,
    2.7,
    3.0,
    2.9,
    3.1,
    3.3,
    3.4,
    3.2,
    3.5,
    3.8,
    4.0,
]  # GDP Growth Rates (in %)
inflation_rates = [
    1.5,
    1.6,
    1.8,
    1.7,
    1.9,
    1.8,
    2.0,
    2.1,
    2.2,
    2.4,
    2.5,
]  # Inflation Rates (in %)
bins = [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
labels = ["GDP Growth Rates", "Inflation Rates"]
xmainlabel = "Time Frame (Years)"
xmainlim = [-0.1, 1.1]
xmainticks = [0.0, 0.2, 0.4, 0.6, 0.8, 1.0]
ymainlabel = "Rates (in %)"
ymainlim = [0, 10]
ymainticks = [0, 2, 4, 6, 8, 10]

xinsetlim = [0.35, 0.85]
xinsetticks = [0.4, 0.6, 0.8]
yinsetlim = [2, 6.5]
yinsetticks = [2,4,6]

# Coordinates for lines connecting the plots (main and inset)
mainplotline = [(0.4, 0), (0.8, 0)]
maininsetline = [(0.5, 0), (0.8, 0)]
title = "Economic Indicators Over Time"
subtitle = "GDP Growth Rates vs Inflation Rates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.05  # Slightly less than the bin width to create a gap
# Colors
gdp_color = "#76c7c0"  # Aqua for GDP Growth Rates
inflation_color = "#555555"  # Gray for Inflation Rates

# Plotting the GDP growth rates
ax_main.bar(
    bins,
    gdp_growth_rates,
    width=bar_width,
    color=gdp_color,
    align="center",
    label=labels[0],
    edgecolor="white",
)
# Plotting the inflation rates
ax_main.bar(
    bins,
    inflation_rates,
    width=bar_width,
    color=inflation_color,
    align="center",
    bottom=gdp_growth_rates,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper right", prop={"size": 16})
plt.title(title, fontsize=20)
plt.suptitle(subtitle, fontsize=12)

# Inset plot configuration
ax_inset = fig.add_axes([0.35, 0.55, 0.3, 0.3])
ax_inset.bar(
    bins[4:],
    gdp_growth_rates[4:],
    width=bar_width,
    color=gdp_color,
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    bins[4:],
    inflation_rates[4:],
    width=bar_width,
    color=inflation_color,
    align="center",
    bottom=gdp_growth_rates[4:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], 0.35),
        (main_plot_left[1], 0.55),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], 0.65),
        (main_plot_right[1], 0.55),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_67.pdf", bbox_inches="tight")
