
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate employment data
years = [i for i in range(2010, 2021)]
unemployment_rate = np.random.uniform(3.5, 9.0, len(years)).round(1).tolist()  # Unemployment rate in %
employment_rate = [(100 - ur) for ur in unemployment_rate]  # Employment rate in %
labels = ["Employment Rate (%)", "Unemployment Rate (%)"]
xmainlabel = "Year"
xmainlim = [2009.5, 2020.5]
xmainticks = [i for i in range(2010, 2021)]
ymainlabel = "Percentage (%)"
ymainlim = [0, 160]
ymainticks = [i * 10 for i in range(17)]

xinsetlim = [2014.5, 2020.5]
xinsetticks = [2015, 2016, 2017, 2018, 2019, 2020]
yinsetlim = [80, 110]
yinsetticks = [i * 10 for i in range(8,12)]

# Coordinates for lines connecting the plots (main and inset)
mainplotline = [(2014.5, 0), (2020.5, 0)]
maininsetline = [(2015, 0), (2020, 0)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define colors
employment_color = "#ffa726"  # Orange for Employment Rate
unemployment_color = "#42a5f5"  # Light Blue for Unemployment Rate

# Create main plot with adjusted bar widths and white borders
fig, ax_main = plt.subplots(figsize=(10, 6))
bar_width = 0.4  # Adjusted bar width
ax_main.bar(
    years,
    employment_rate,
    width=bar_width,
    color=employment_color,
    align="center",
    label=labels[0],
    edgecolor="white",
)
ax_main.bar(
    years,
    unemployment_rate,
    width=bar_width,
    color=unemployment_color,
    align="center",
    bottom=employment_rate,
    label=labels[1],
    edgecolor="white",
)
ax_main.set_xlabel(xmainlabel)
ax_main.set_xlim(xmainlim)
ax_main.set_xticks(xmainticks)
ax_main.set_ylabel(ymainlabel)
ax_main.set_ylim(ymainlim)
ax_main.set_yticks(ymainticks)
ax_main.legend(loc="upper left", prop={"size": 12})

# Inset plot configuration
ax_inset = fig.add_axes([0.55, 0.7, 0.25, 0.25])
ax_inset.bar(
    years[5:],
    employment_rate[5:],
    width=bar_width,
    color=employment_color,
    align="center",
    edgecolor="white",
)
ax_inset.bar(
    years[5:],
    unemployment_rate[5:],
    width=bar_width,
    color=unemployment_color,
    align="center",
    bottom=employment_rate[5:],
    edgecolor="white",
)
ax_inset.set_xlim(xinsetlim)  # Zoom in on the right part of the data
ax_inset.set_xticks(xinsetticks)
ax_inset.set_ylim(yinsetlim)
ax_inset.set_yticks(yinsetticks)

# Adding lines to connect the plots.
# Coordinates of the main plot corners
main_plot_left = ax_main.transData.transform_point(mainplotline[0])
main_plot_right = ax_main.transData.transform_point(mainplotline[1])

# Coordinates of the inset corners
inset_left = ax_inset.transData.transform_point(maininsetline[0])
inset_right = ax_inset.transData.transform_point(maininsetline[1])

# Transform to figure coordinates for annotation
main_plot_left = fig.transFigure.inverted().transform(main_plot_left)
main_plot_right = fig.transFigure.inverted().transform(main_plot_right)
inset_left = fig.transFigure.inverted().transform(inset_left)
inset_right = fig.transFigure.inverted().transform(inset_right)

# Draw lines connecting corners
fig.add_artist(
    plt.Line2D(
        (main_plot_left[0], inset_left[0]),
        (main_plot_left[1], 0.7),
        color="gray",
    )
)
fig.add_artist(
    plt.Line2D(
        (main_plot_right[0], inset_right[0]),
        (main_plot_right[1], 0.7),
        color="gray",
    )
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("PIP_68.pdf", bbox_inches="tight")
