
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Generate New Data
import numpy as np

# Simulated Publication Data for plotting
years = np.array([2000, 2005, 2010, 2015, 2020])
publications_exp_kant = np.array([5, 10, 20, 40, 80])  # Exponential growth for Kant
publications_lin_kant = np.array([5, 10, 15, 20, 25])  # Linear growth for Kant
publications_exp_nietzsche = np.array([3, 6, 12, 24, 48])  # Exponential growth for Nietzsche
publications_lin_nietzsche = np.array([3, 6, 9, 12, 15])  # Linear growth for Nietzsche

# New Labels and tick mark settings
labels = [
    "Kant | Exponential Growth",
    "Kant | Linear Growth",
    "Nietzsche | Exponential Growth",
    "Nietzsche | Linear Growth",
]
xlabel = "Year"
ylabel = "Number of Publications"
title = "Publication Growth of Kant and Nietzsche (2000-2020)"

xticks = years
yticks = np.linspace(0, 100, 6)
yticklabels = [f"{int(x)}" for x in yticks]
inset_axes = [0.22, 0.35, 0.3, 0.25]
inset_ylim = [0, 80]
yticks_inset = np.linspace(0, 80, 6)
x_years = [f"{int(x)}" for x in years]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data with different styles and colors
ax.plot(years, publications_exp_kant, "o-", label=labels[0], color="green")
ax.plot(years, publications_lin_kant, "x--", label=labels[1], color="green")
ax.plot(years, publications_exp_nietzsche, "o-", label=labels[2], color="blue")
ax.plot(years, publications_lin_nietzsche, "x--", label=labels[3], color="blue")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis limits and ticks
ax.set_ylim([0, 100])
ax.set_yticks(yticks)
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend()

# Create an inset axis for Kant data
ax_inset = fig.add_axes(inset_axes)
ax_inset.plot(years, publications_exp_kant, "o-", color="green")
ax_inset.plot(years, publications_lin_kant, "x--", color="green")

# Adjust y-axis limits for inset
ax_inset.set_ylim(inset_ylim)
ax_inset.set_xlim([2000, 2020])
ax_inset.set_yticks(yticks_inset)

# Change x-axis tick labels to years
ax.set_xticks(years)
ax.set_xticklabels(x_years)
ax_inset.set_xticks(years)
ax_inset.set_xticklabels(x_years)

# --------------------
# Part 4: Saving Output
# --------------------
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_70.pdf", bbox_inches="tight")
