
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated data for cumulative artworks created by four types of artists over a 38-month period
np.random.seed(0)
x = np.linspace(1, 38, 38)
y1 = np.cumsum(np.random.poisson(3, 38))  # Painters
y2 = np.cumsum(np.random.poisson(4, 38))  # Sculptors
y3 = np.cumsum(np.random.poisson(5, 38))  # Digital Artists
y4 = np.cumsum(np.random.poisson(2, 38))  # Mixed Media Artists

# Labels and Plot Types
label_Painters = "Painters"
label_Sculptors = "Sculptors"
label_DigitalArtists = "Digital Artists"
label_MixedMediaArtists = "Mixed Media Artists"

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Cumulative Artworks Created"
zoomed_in_axes = [0.15, 0.5, 0.25, 0.25]
xlim_values = [33, 38]
ylim_values = [y1[32], max(y1[37], y2[37], y3[37], y4[37]) + 2]
xticks_values = [33, 35, 37]
yticks_values = list(range(int(ylim_values[0]), int(ylim_values[1]) + 20, 20))
title = "Artworks Created by Different Artists Over 38 Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the curves with distinct styles
ax.plot(
    x, y1, color="#1f77b4", linestyle="-", linewidth=2, marker="o", label=label_Painters
)
ax.plot(
    x,
    y2,
    color="#2ca02c",
    linestyle="--",
    linewidth=2,
    marker="x",
    label=label_Sculptors,
)
ax.plot(
    x,
    y3,
    color="#d62728",
    linestyle="-.",
    linewidth=2,
    marker="s",
    label=label_DigitalArtists,
)
ax.plot(
    x, y4, color="#9467bd", linestyle=":", linewidth=2, marker="d", label=label_MixedMediaArtists
)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)

# Create the inset with the zoomed-in view
ax_inset = fig.add_axes(
    zoomed_in_axes
)  # Adjust the position to align with the right side of the main plot
ax_inset.plot(x, y1, color="#1f77b4", linestyle="-", linewidth=2, marker="o")
ax_inset.plot(x, y2, color="#2ca02c", linestyle="--", linewidth=2, marker="x")
ax_inset.plot(x, y3, color="#d62728", linestyle="-.", linewidth=2, marker="s")
ax_inset.plot(x, y4, color="#9467bd", linestyle=":", linewidth=2, marker="d")
ax_inset.set_xlim(xlim_values)
ax_inset.set_ylim(ylim_values)
ax_inset.set_xticks(xticks_values)
ax_inset.set_yticks(yticks_values)
ax_inset.spines["bottom"].set_color("black")  # Add black border to the inset
ax_inset.spines["left"].set_color("black")
ax_inset.spines["top"].set_color("black")
ax_inset.spines["right"].set_color("black")

# Add the legend to the main axis, outside the plot area
ax.legend(loc="lower right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("PIP_72.pdf", bbox_inches="tight")
