
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x = np.arange(1, 13)  # 12 months
# Sales data for four products
sales_product1 = [120, 150, 180, 170, 160, 200, 220, 210, 240, 260, 300, 280]
sales_product2 = [100, 120, 140, 130, 120, 150, 180, 170, 190, 210, 240, 220]
sales_product3 = [80, 100, 130, 110, 100, 130, 150, 140, 160, 180, 220, 200]
sales_product4 = [60, 80, 100, 90, 80, 100, 120, 110, 130, 150, 180, 160]

# Labels for legend
label_product1 = "Product 1 Sales"
label_product2 = "Product 2 Sales"
label_product3 = "Product 3 Sales"
label_product4 = "Product 4 Sales"

# Horizontal line value for average monthly sales
axhline_value = 150

# Axis labels and title
xlabel_values = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
ylabel_values = range(50, 351, 50)  # y-axis values from 50 to 350 with a step of 50
chart_title = "Monthly Sales Data"
chart_xlabel = "Months"
chart_ylabel = "Sales (Units)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size

# Plot limits
xlim_values = (1, 12)
ylim_values = (50, 350)

# Plot lines with different styles and colors
plt.plot(
    x,
    sales_product1,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff7f0e",
    markeredgecolor="#d62728",
    markersize=8,
    color="#d62728",
    label=label_product1,
    linewidth=2
)
plt.plot(
    x,
    sales_product2,
    "^-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f77b4",
    markeredgecolor="#1f77b4",
    markersize=8,
    color="#1f77b4",
    label=label_product2,
    linewidth=2
)
plt.plot(
    x,
    sales_product3,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=8,
    color="#2ca02c",
    label=label_product3,
    linewidth=2
)
plt.plot(
    x,
    sales_product4,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#9467bd",
    markeredgecolor="#9467bd",
    markersize=8,
    color="#9467bd",
    label=label_product4,
    linewidth=2
)

# Filling the area under the curves
plt.fill_between(x, sales_product1, sales_product2, color="#ff7f0e", alpha=0.3)
plt.fill_between(x, sales_product2, sales_product3, color="#1f77b4", alpha=0.3)
plt.fill_between(x, sales_product3, sales_product4, color="#2ca02c", alpha=0.3)
plt.fill_between(x, sales_product4, color="#9467bd", alpha=0.3)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels and y-axis tick labels
plt.xticks(x, xlabel_values)
plt.yticks(ylabel_values)

# Adding title and labels
plt.title(chart_title, fontsize=14)
plt.xlabel(chart_xlabel, fontsize=12)
plt.ylabel(chart_ylabel, fontsize=12)

# Adding a legend
plt.legend(loc="upper right", frameon=False)

plt.gca().tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_23.pdf", bbox_inches="tight")
