
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data
time_step = np.linspace(0, 24, 100)
em_car = 5 + np.sin(time_step / 3)
em_bus = 2 + np.sin(time_step / 3 + 0.5)
em_scooter = 1 + np.sin(time_step / 3 + 1)

be_car = 90 + 5 * np.cos(time_step / 2)
be_bus = 80 + 5 * np.cos(time_step / 2 + 0.5)
be_scooter = 70 + 5 * np.cos(time_step / 2 + 1)

# Extracted variables
em_car_label = "Car"
em_bus_label = "Bus"
em_scooter_label = "Scooter"
be_car_label = "Car"
be_bus_label = "Bus"
be_scooter_label = "Scooter"

em_ylabel = "Emission Level (g/km)"
be_xlabel = "Time (h)"
be_ylabel = "Battery Efficiency (%)"
legend_labels = ["Car", "Bus", "Scooter"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Color variables
em_fill_color_car = "#FFF0E0"
em_fill_color_bus = "#D7E3F5"
em_fill_color_scooter = "#E2F0E2"
be_fill_color_car = "#FFF0E0"
be_fill_color_bus = "#D7E3F5"
be_fill_color_scooter = "#E2F0E2"

em_ylim = [0, 10]
em_xlim = [0, 24]
em_yticks = [0, 2, 4, 6, 8, 10]
em_xticks = [0, 4, 8, 12, 16, 20, 24]

be_ylim = [60, 100]
be_xlim = [0, 24]
be_yticks = [60, 70, 80, 90, 100]
be_xticks = [0, 4, 8, 12, 16, 20, 24]

# Plot Emission Level
ax1.plot(time_step, em_car, "o-", color="#FFA500", label=em_car_label)
ax1.fill_between(time_step, em_car, color=em_fill_color_car)
ax1.plot(time_step, em_bus, "s-", color="#4682B4", label=em_bus_label)
ax1.fill_between(time_step, em_bus, color=em_fill_color_bus)
ax1.plot(time_step, em_scooter, "^-", color="#32CD32", label=em_scooter_label)
ax1.fill_between(time_step, em_scooter, color=em_fill_color_scooter)
ax1.set_ylim(em_ylim)
ax1.set_xlim(em_xlim)
ax1.set_yticks(em_yticks)
ax1.set_xticks(em_xticks)
ax1.set_ylabel(em_ylabel)
ax1.tick_params(axis="both", which="both", length=0)

# Plot Battery Efficiency
ax2.plot(time_step, be_car, "o-", color="#FFA500", label=be_car_label)
ax2.fill_between(time_step, be_car, color=be_fill_color_car)
ax2.plot(time_step, be_bus, "s-", color="#4682B4", label=be_bus_label)
ax2.fill_between(time_step, be_bus, color=be_fill_color_bus)
ax2.plot(time_step, be_scooter, "^-", color="#32CD32", label=be_scooter_label)
ax2.fill_between(time_step, be_scooter, color=be_fill_color_scooter)
ax2.set_ylim(be_ylim)
ax2.set_xlim(be_xlim)
ax2.set_yticks(be_yticks)
ax2.set_xticks(be_xticks)
ax2.set_xlabel(be_xlabel)
ax2.set_ylabel(be_ylabel)
ax2.tick_params(axis="both", which="both", length=0)

# Create custom legend
orange_line = mlines.Line2D([], [], color="#FFA500", marker="o", markersize=6, label=legend_labels[0])
blue_line = mlines.Line2D([], [], color="#4682B4", marker="s", markersize=6, label=legend_labels[1])
green_line = mlines.Line2D([], [], color="#32CD32", marker="^", markersize=6, label=legend_labels[2])
plt.legend(handles=[orange_line, blue_line, green_line], loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_26.pdf", bbox_inches="tight")
