
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plot with basketball teams average points per game
years = np.array([2010, 2012, 2014, 2016, 2018])
team_a = np.array([80, 82, 85, 87, 90]) + np.random.normal(0, 2, 5)  # Avg points per game
team_b = np.array([75, 77, 80, 83, 86]) + np.random.normal(0, 2, 5)
team_c = np.array([78, 79, 82, 84, 87]) + np.random.normal(0, 2, 5)
team_d = np.array([70, 72, 75, 77, 80]) + np.random.normal(0, 2, 5)
global_avg = np.linspace(80, 80, len(years))  # Average points line

# Labels and parameters for basketball teams
fill_label_team_a = "Team A"
fill_label_team_b = "Team B"
fill_label_team_c = "Team C"
fill_label_team_d = "Team D"
plot_label_global_avg = "Average Points"
title_text = "Basketball Teams Average Points Per Game Over Years"
xlabel_text = "Year"
ylabel_text = "Average Points Per Game"
legend_title = "Teams"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot with a different visualization style
plt.figure(figsize=(10, 6))

xlim_values = (min(years), max(years))
ylim_values = (65.0, 95.0)
xticks_values = years
yticks_values = np.arange(65.0, 96.0, 5.0)
legend_loc = "upper left"
legend_bbox_to_anchor = (0.0, 1.0)
legend_ncol = 1

# Plotting data
plt.fill_between(years, team_a, color="#66c2a5", alpha=0.5, label=fill_label_team_a)
plt.fill_between(years, team_b, color="#fc8d62", alpha=0.5, label=fill_label_team_b)
plt.fill_between(years, team_c, color="#8da0cb", alpha=0.5, label=fill_label_team_c)
plt.fill_between(years, team_d, color="#e78ac3", alpha=0.5, label=fill_label_team_d)
plt.plot(years, global_avg, color="#a6d854", linestyle="--", linewidth=2, label=plot_label_global_avg)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=14, y=1.05)
plt.xlabel(xlabel_text, fontsize=12)
plt.ylabel(ylabel_text, fontsize=12)
plt.xticks(xticks_values)
plt.yticks(yticks_values)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    reverse=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_28.pdf", bbox_inches="tight")
