
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

decade = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
popularity_by_language = {
    "Fortran": [10, 40, 70, 90, 100, 80, 60, 50],
    "C": [5, 30, 80, 150, 200, 180, 160, 140],
    "Python": [0, 0, 0, 20, 100, 200, 300, 350],
    "Java": [0, 0, 0, 0, 50, 150, 250, 300],
    "JavaScript": [0, 0, 0, 0, 10, 60, 180, 300],
}

# Extracted variables
legend_labels = list(popularity_by_language.keys())
xlabel_value = "Decade"
ylabel_value = "Popularity Score"
title_value = "Popularity of Programming Languages over Decades"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))

xlim_values = (1950, 2020)
ylim_values = (0, 1200)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = False
legend_ncol = 1
legend_bbox_to_anchor = (1.02, 1)
title_y_position = 1.02
colors = ["#4863A0", "#D16587", "#91C8E3", "#F19E8E", "#679D8B"]

ax.stackplot(
    decade,
    popularity_by_language.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_33.pdf", bbox_inches="tight")
