

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# New data for communication domain
year = [1950, 1960, 1970, 1980, 1990, 2000, 2010, 2020]
users_by_medium = {
    "Television": [10, 50, 100, 200, 300, 400, 450, 450],
    "Radio": [50, 80, 120, 150, 160, 150, 140, 130],
    "Internet": [0, 0, 0, 0, 50, 200, 400, 600],
    "Print": [100, 120, 130, 150, 170, 150, 130, 100],
    "Mobile Communication": [0, 0, 0, 50, 100, 300, 500, 700]
}

# Extracted variables for the new plot
legend_labels = list(users_by_medium.keys())
xlabel_value = "Year"
ylabel_value = "Number of Users (millions)"
title_value = "Communication Medium Users Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))

xlim_values = (1950, 2020)
ylim_values = (0, 2000)
legend_loc = "upper left"
legend_reverse = False
legend_frameon = True
legend_ncol = 1
legend_bbox_to_anchor = (1, 1)
title_y_position = 1.05
colors = ["#d4a373", "#a98467", "#6f4e37", "#3f301d", "#2f1b0c"]

ax.stackplot(
    year,
    users_by_medium.values(),
    labels=legend_labels,
    alpha=0.85,
    colors=colors,
)
ax.legend(
    loc=legend_loc,
    reverse=legend_reverse,
    frameon=legend_frameon,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
)
ax.set_xlim(*xlim_values)
ax.set_ylim(*ylim_values)
ax.set_title(title_value, y=title_y_position)
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_34.pdf", bbox_inches="tight")

