

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
years = [2010, 2012, 2014, 2016, 2018, 2020]
temperature = [15, 16, 16.5, 17, 16, 16.8]  # Average Temperature (°C)
precipitation = [100, 105, 110, 95, 85, 90]  # Average Precipitation (mm)
humidity = [70, 72, 75, 74, 71, 69]  # Average Humidity (%)

# Labels for legend
label_temperature = "Temperature"
label_precipitation = "Precipitation"
label_humidity = "Humidity"

# Title and labels
plot_title = "Weather Patterns Over the Years"
xlabel_text = "Years"
ylabel_text = "Measurements"

xlim_values = (2010, 2020)
ylim_values = (0, 120)

# Axis labels
xlabel_values = ["2010", "2012", "2014", "2016", "2018", "2020"]
ylabel_values = [0, 20, 40, 60, 80, 100, 120]

# Axis ticks
xticks_values = years
yticks_values = [0, 20, 40, 60, 80, 100, 120]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot limits

# Plotting the data
title_fontsize = 16
label_fontsize = 14
title_pad = 20
plt.figure(figsize=(12, 8))  # Adjusting figure size to fit better
plt.plot(
    years,
    temperature,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1f77b4",
    markeredgecolor="#1f77b4",
    markersize=10,
    color="#1f77b4",
    label=label_temperature,
)
plt.plot(
    years,
    precipitation,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#d62728",
    markeredgecolor="#d62728",
    markersize=10,
    color="#d62728",
    label=label_precipitation,
)
plt.plot(
    years,
    humidity,
    "d-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#2ca02c",
    markeredgecolor="#2ca02c",
    markersize=10,
    color="#2ca02c",
    label=label_humidity,
)

# Filling the area under the curves
plt.fill_between(years, temperature, precipitation, color="#1f77b4", alpha=0.4)
plt.fill_between(years, precipitation, humidity, color="#d62728", alpha=0.4)
plt.fill_between(years, humidity, 0, color="#2ca02c", alpha=0.4)

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis and y-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend
plt.legend(loc="upper left", frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding title and labels
plt.title(plot_title, fontsize=title_fontsize, pad=title_pad)
plt.xlabel(xlabel_text, fontsize=label_fontsize)
plt.ylabel(ylabel_text, fontsize=label_fontsize)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_38.pdf", bbox_inches="tight")

