
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting (Types of Complaints over Years)
years = [2010, 2012, 2014, 2016, 2018, 2020]
noise_complaints = [120, 150, 175, 200, 225, 210]
parking_complaints = [90, 130, 160, 140, 190, 220]
garbage_complaints = [80, 105, 115, 140, 145, 160]
vandalism_complaints = [60, 65, 75, 85, 95, 110]

# Labels for legend
label_noise = "Noise Complaints"
label_parking = "Parking Complaints"
label_garbage = "Garbage Complaints"
label_vandalism = "Vandalism Complaints"

# Horizontal line value
axhline_value = 150

# Chart text labels
title = "Number of Complaints Received by City Council Over the Years"
xlabel = "Year"
ylabel = "Number of Complaints"
xlabel_values = ["2010", "2012", "2014", "2016", "2018", "2020"]
ylabel_values = range(0, 301, 50)
xticks_values = years
yticks_values = range(0, 301, 50)

# Plot limits
xlim_values = (2010, 2020)
ylim_values = (0, 300)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))

# Color variables
color_noise = "#377eb8"
color_parking = "#4daf4a"
color_garbage = "#984ea3"
color_vandalism = "#e41a1c"
edge_color_noise = "#345b9e"
edge_color_parking = "#3b8b3a"
edge_color_garbage = "#7a3c7e"
edge_color_vandalism = "#b01716"

plt.plot(
    years,
    noise_complaints,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_noise,
    markeredgecolor=edge_color_noise,
    markersize=10,
    color=edge_color_noise,
    label=label_noise,
)
plt.plot(
    years,
    parking_complaints,
    "s--",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_parking,
    markeredgecolor=edge_color_parking,
    markersize=10,
    color=edge_color_parking,
    label=label_parking,
)
plt.plot(
    years,
    garbage_complaints,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_garbage,
    markeredgecolor=edge_color_garbage,
    markersize=10,
    color=edge_color_garbage,
    label=label_garbage,
)
plt.plot(
    years,
    vandalism_complaints,
    "^:",
    clip_on=False,
    zorder=10,
    markerfacecolor=color_vandalism,
    markeredgecolor=edge_color_vandalism,
    markersize=10,
    color=edge_color_vandalism,
    label=label_vandalism,
)

# Filling the area under the curves
plt.fill_between(years, noise_complaints, parking_complaints, color=color_noise, alpha=0.2)
plt.fill_between(years, parking_complaints, garbage_complaints, color=color_parking, alpha=0.2)
plt.fill_between(years, garbage_complaints, vandalism_complaints, color=color_garbage, alpha=0.2)
plt.fill_between(years, vandalism_complaints, color=color_vandalism, alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# Adding chart title and axis labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_39.pdf", bbox_inches="tight")
