

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting (Observations of Community Services Over Years)
years = [2015, 2016, 2017, 2018, 2019]
healthcare_initiatives = [50, 70, 65, 80, 90]
educational_programs = [100, 130, 120, 150, 160]
environmental_projects = [40, 55, 50, 60, 75]
sports_programs = [20, 30, 35, 40, 45]

# Labels for legend
label_healthcare = "Healthcare Initiatives"
label_education = "Educational Programs"
label_environment = "Environmental Projects"
label_sports = "Sports Programs"

# Horizontal line value
axhline_value = 100

# Axis labels
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = [20, 40, 60, 80, 100, 120, 140, 160]

# Plot limits
xlim_values = (2015, 2019)
ylim_values = (0, 160)

# Axis ticks
xticks_values = years
yticks_values = [20, 40, 60, 80, 100, 120, 140, 160]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    healthcare_initiatives,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ff9999",
    markeredgecolor="#cc6666",
    markersize=10,
    color="#cc6666",
    label=label_healthcare,
)
plt.plot(
    years,
    educational_programs,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#99ccff",
    markeredgecolor="#6699cc",
    markersize=10,
    color="#6699cc",
    label=label_education,
)
plt.plot(
    years,
    environmental_projects,
    "^--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#99ff99",
    markeredgecolor="#66cc66",
    markersize=10,
    color="#66cc66",
    label=label_environment,
)
plt.plot(
    years,
    sports_programs,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor="#ffcc99",
    markeredgecolor="#cc9966",
    markersize=10,
    color="#cc9966",
    label=label_sports,
)

# Filling the area under the curves
plt.fill_between(years, healthcare_initiatives, educational_programs, color="#ff9999", alpha=0.2)
plt.fill_between(years, educational_programs, environmental_projects, color="#99ccff", alpha=0.2)
plt.fill_between(years, environmental_projects, sports_programs, color="#99ff99", alpha=0.2)
plt.fill_between(years, sports_programs, color="#ffcc99", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis、y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_40.pdf", bbox_inches="tight")

