
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# New data imports
import numpy as np

# Data for plotting (Influence Scores of Philosophical Schools over Years)
years = [2015, 2016, 2017, 2018, 2019]
existentialism_influence = [70, 75, 72, 78, 80]
rationalism_influence = [65, 68, 70, 73, 75]
empiricism_influence = [60, 62, 65, 67, 70]
idealism_influence = [50, 55, 57, 60, 62]

# Labels for legend
label_existentialism = "Existentialism Influence"
label_rationalism = "Rationalism Influence"
label_empiricism = "Empiricism Influence"
label_idealism = "Idealism Influence"

# Horizontal line value
axhline_value = 60

# Plot limits
xlim_values = (2015, 2019)
ylim_values = (45, 85)

# Axis labels
xlabel_values = ["2015", "2016", "2017", "2018", "2019"]
ylabel_values = [45, 50, 55, 60, 65, 70, 75, 80, 85]

# Axis ticks
xticks_values = years
yticks_values = [45, 50, 55, 60, 65, 70, 75, 80, 85]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    years,
    existentialism_influence,
    "s-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#1b9e77",
    markeredgecolor="#1b9e77",
    markersize=10,
    color="#1b9e77",
    label=label_existentialism,
)
plt.plot(
    years,
    rationalism_influence,
    "o-",
    clip_on=False,
    zorder=10,
    markerfacecolor="#d95f02",
    markeredgecolor="#d95f02",
    markersize=10,
    color="#d95f02",
    label=label_rationalism,
)
plt.plot(
    years,
    empiricism_influence,
    "^--",
    clip_on=False,
    zorder=10,
    markerfacecolor="#7570b3",
    markeredgecolor="#7570b3",
    markersize=10,
    color="#7570b3",
    label=label_empiricism,
)
plt.plot(
    years,
    idealism_influence,
    "d-.",
    clip_on=False,
    zorder=10,
    markerfacecolor="#e7298a",
    markeredgecolor="#e7298a",
    markersize=10,
    color="#e7298a",
    label=label_idealism,
)

# Filling the area under the curves
plt.fill_between(years, existentialism_influence, rationalism_influence, color="#1b9e77", alpha=0.2)
plt.fill_between(years, rationalism_influence, empiricism_influence, color="#d95f02", alpha=0.2)
plt.fill_between(years, empiricism_influence, idealism_influence, color="#7570b3", alpha=0.2)
plt.fill_between(years, idealism_influence, color="#e7298a", alpha=0.2)

# Adding a horizontal dashed line at y=axhline_value
plt.axhline(axhline_value, color="black", linestyle="dotted")

# Setting the x-axis and y-axis limits
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Setting the x-axis tick labels
plt.xticks(xticks_values, xlabel_values)
plt.yticks(yticks_values, ylabel_values)

# Adding a legend at the bottom
plt.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), frameon=False)
plt.gca().tick_params(axis="both", which="both", length=0)

# Adding grid lines for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# Adding title
plt.title("Influence Scores of Philosophical Schools (2015-2019)")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("area_41.pdf", bbox_inches="tight")
