
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Simulated data for average temperatures over months
months = np.linspace(1, 12, 12)  # 12 months
avg_temperatures = np.array(
    [0, 3, 7, 12, 18, 21, 25, 24, 19, 13, 7, 2]
)
avg_temperatures_pred = avg_temperatures + np.random.normal(0, 1.5, len(avg_temperatures))

# Simulated data for monthly rainfall (in mm)
rainfall = np.array([75, 80, 65, 70, 85, 90, 100, 105, 95, 80, 70, 65])
rainfall_pred = rainfall + np.random.normal(0, 5, len(rainfall))

# Extracted variables
temp_label = "Actual Avg Temperature (°C)"
temp_pred_label = "Predicted Avg Temperature (°C)"
rain_label = "Actual Rainfall (mm)"
rain_pred_label = "Predicted Rainfall (mm)"

temp_ylabel = "Avg Temperature (°C)"
rain_xlabel = "Months"
rain_ylabel = "Rainfall (mm)"
legend_labels = ["Actual", "Predicted"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
temp_ylim = [-5, 30]
temp_xlim = [1, 12]
temp_yticks = [-5, 0, 5, 10, 15, 20, 25, 30]
temp_xticks = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]

rain_ylim = [50, 150]
rain_xlim = [1, 12]
rain_yticks = [50, 75, 100, 125, 150]
rain_xticks = temp_xticks

legend_loc = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 12))

# Plot Average Temperatures
ax1.plot(months, avg_temperatures, "o-", color="#1f77b4", label=temp_label, linewidth=2)
ax1.fill_between(months, avg_temperatures, color="#aec7e8", alpha=0.5)
ax1.plot(months, avg_temperatures_pred, "s-", color="#ff7f0e", label=temp_pred_label, linewidth=2)
ax1.fill_between(months, avg_temperatures_pred, color="#ffbb78", alpha=0.5)
ax1.set_ylim(temp_ylim)
ax1.set_xlim(temp_xlim)
ax1.set_yticks(temp_yticks)
ax1.set_xticks(temp_xticks)
ax1.set_ylabel(temp_ylabel)
ax1.tick_params(axis="both", which="both", length=0, labelsize=12)

# Plot Rainfall
ax2.plot(months, rainfall, "o-", color="#1f77b4", label=rain_label, linewidth=2)
ax2.fill_between(months, rainfall, color="#aec7e8", alpha=0.5)
ax2.plot(months, rainfall_pred, "s-", color="#ff7f0e", label=rain_pred_label, linewidth=2)
ax2.fill_between(months, rainfall_pred, color="#ffbb78", alpha=0.5)
ax2.set_ylim(rain_ylim)
ax2.set_xlim(rain_xlim)
ax2.set_yticks(rain_yticks)
ax2.set_xticks(rain_xticks)
ax2.set_xlabel(rain_xlabel, fontsize=14)
ax2.set_ylabel(rain_ylabel, fontsize=14)
ax2.tick_params(axis="both", which="both", length=0, labelsize=12)

# Create custom legend
blue_circle = mlines.Line2D([], [], color="#1f77b4", marker="o", markersize=6, label=legend_labels[0])
orange_square = mlines.Line2D([], [], color="#ff7f0e", marker="s", markersize=6, label=legend_labels[1])
plt.legend(handles=[blue_circle, orange_square], loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_42.pdf", bbox_inches="tight")
