
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Sample data for 12 months
months = np.arange(1, 13)
average_temperature = 15 + 10 * np.cos(np.pi * months / 6)
precipitation_levels = np.random.uniform(20, 100, size=12)

# Extracted variables for labels and settings
temperature_label = "Average Temperature (°C)"
precipitation_label = "Precipitation Levels (mm)"

legend_labels = ["Temperature", "Precipitation"]
temperature_ylabel = "Average Temperature (°C)"
precipitation_ylabel = "Precipitation Levels (mm)"
monthly_xlabel = "Month"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
temperature_ylim = [-10, 35]
precipitation_ylim = [0, 120]
months_xticks = np.arange(1, 13, 1)
months_xlim = [1, 12]
yticks_temperature = np.arange(-10, 36, 5)
yticks_precipitation = np.arange(0, 121, 20)
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, -0.15)
legend_ncol = 2
legend_frameon = False

# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(12, 23))

# Plot Average Temperature
ax1.plot(months, average_temperature, "o-", color="#32CD32", label=temperature_label)
ax1.set_ylim(temperature_ylim)
ax1.set_xlim(months_xlim)
ax1.set_xticks(months_xticks)
ax1.set_ylabel(temperature_ylabel)
ax1.tick_params(axis="both", which="both", length=0)
ax1.grid(True)

# Plot Precipitation Levels
ax2.plot(months, precipitation_levels, "s--", color="#FFA500", label=precipitation_label)
ax2.set_ylim(precipitation_ylim)
ax2.set_xlim(months_xlim)
ax2.set_yticks(yticks_precipitation)
ax2.set_xticks(months_xticks)
ax2.set_xlabel(monthly_xlabel)
ax2.set_ylabel(precipitation_ylabel)
ax2.tick_params(axis="both", which="both", length=0)
ax2.grid(True)

# Create custom legend
green_dot = mlines.Line2D(
    [], [], color="#32CD32", marker="o", markersize=8, label=legend_labels[0], linestyle="None"
)
orange_square = mlines.Line2D(
    [], [], color="#FFA500", marker="s", markersize=8, label=legend_labels[1], linestyle="None"
)
plt.legend(
    handles=[green_dot, orange_square],
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("area_45.pdf", bbox_inches="tight")
