
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data representing average renewable energy production in different regions over years (in megawatts)
years = np.array([2010, 2012, 2014, 2016, 2018, 2020])

region1_production = np.array([150, 200, 300, 400, 500, 600]) + np.random.normal(0, 20, 6)
region2_production = np.array([100, 150, 250, 350, 450, 550]) + np.random.normal(0, 20, 6)
region3_production = np.array([80, 130, 180, 230, 300, 380]) + np.random.normal(0, 20, 6)
region4_production = np.array([90, 140, 210, 300, 370, 460]) + np.random.normal(0, 20, 6)

# Extracted variables
fill_label_region1 = "Region 1"
fill_label_region2 = "Region 2"
fill_label_region3 = "Region 3"
fill_label_region4 = "Region 4"
title_text = "Average Renewable Energy Production Over Years"
xlabel_text = "Year"
ylabel_text = "Production (MW)"
legend_title = "Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (min(years), max(years))
ylim_values = (50, 650)
xticks_values = years
yticks_values = np.arange(50, 651, 100)
legend_loc = "upper left"
legend_bbox_to_anchor = (1, 1)
legend_ncol = 1
# Color definitions (unchanged)
colors = {
    "region1": "#8B4513",
    "region2": "#228B22",
    "region3": "#FFD700",
    "region4": "#1E90FF",
}

# Create the plot with a different visualization style
plt.figure(figsize=(10, 7))
plt.fill_between(years, region1_production, color=colors["region1"], alpha=0.6, label=fill_label_region1)
plt.fill_between(years, region2_production, color=colors["region2"], alpha=0.6, label=fill_label_region2)
plt.fill_between(years, region3_production, color=colors["region3"], alpha=0.6, label=fill_label_region3)
plt.fill_between(years, region4_production, color=colors["region4"], alpha=0.6, label=fill_label_region4)

# Add a title and labels
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)

# Adding a legend with a title
plt.legend(
    title=legend_title,
    frameon=False,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_49.pdf", bbox_inches="tight")
