

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with different tourism metrics
months = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])
num_tourists = np.array([45, 50, 60, 70, 85, 100, 110, 105, 90, 75, 60, 50]) + np.random.uniform(-5, 5, 12)
hotel_occupancy = np.array([75, 78, 82, 88, 92, 95, 98, 97, 93, 87, 80, 76]) + np.random.uniform(-3, 3, 12)
avg_expenditure = np.array([80, 20, 40, 60, 90, 60, 40, 30, 55, 72, 60, 90]) + np.random.uniform(-20, 20, 12)
satisfaction_index = np.array([68, 70, 73, 76, 79, 82, 84, 83, 80, 77, 72, 69]) + np.random.uniform(-2, 2, 12)
benchmark_tourism_goal = np.linspace(70, 70, len(months))  # Benchmark line

# Extracted variables for labels
fill_label_tourists = "Number of Tourists (thousands)"
fill_label_occupancy = "Hotel Occupancy Rate (%)"
fill_label_expenditure = "Avg Expenditure per Tourist ($)"
fill_label_satisfaction = "Tourists' Satisfaction Index (%)"
plot_label_benchmark = "Monthly Tourism Goal"
title_text = "Tourism Metrics Over 12 Months"
xlabel_text = "Months"
ylabel_text = "Tourism Metrics and Rates"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (0, 120)
xticks_values = months
yticks_values = [50, 100, 150, 200, 250, 300]
legend_loc = "upper left"
legend_bbox_to_anchor = (1.05, 1)
legend_ncol = 1

# Create the plot with an educational style
plt.figure(figsize=(12, 7))
plt.fill_between(
    months, num_tourists, color="#4c72b0", alpha=0.3, label=fill_label_tourists
)
plt.fill_between(
    months, hotel_occupancy, color="#dd8452", alpha=0.3, label=fill_label_occupancy
)
plt.fill_between(
    months, avg_expenditure, color="#55a868", alpha=0.3, label=fill_label_expenditure
)
plt.fill_between(
    months, satisfaction_index, color="#c44e52", alpha=0.3, label=fill_label_satisfaction
)
plt.plot(
    months,
    benchmark_tourism_goal,
    color="#8172b2",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=18, y=1.02)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_51.pdf", bbox_inches="tight")

