
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with different philosophical metrics
periods = np.array([1, 2, 3, 4, 5, 6])
existentialism_interest = np.array([60, 75, 70, 85, 80, 90]) + np.random.uniform(-5, 5, 6)
stoicism_interest = np.array([50, 60, 55, 65, 60, 70]) + np.random.uniform(-5, 5, 6)
rationalism_interest = np.array([30, 35, 28, 40, 38, 45]) + np.random.uniform(-4, 4, 6)
empiricism_interest = np.array([40, 45, 43, 50, 46, 52]) + np.random.uniform(-4, 4, 6)
benchmark_philosophy = np.linspace(50, 50, len(periods))  # Benchmark line

# Extracted variables for labels
fill_label_existentialism = "Existentialism"
fill_label_stoicism = "Stoicism"
fill_label_rationalism = "Rationalism"
fill_label_empiricism = "Empiricism"
plot_label_benchmark = "Benchmark"
title_text = "Philosophical Movements Interest Over Time"
xlabel_text = "Time Periods"
ylabel_text = "Interest Level (0-100)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (20, 100)
xticks_values = periods
yticks_values = [20, 40, 60, 80, 100]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.08)
legend_ncol = 5

# Color and transparency settings
color_existentialism = "skyblue"
color_stoicism = "lightgreen"
color_rationalism = "coral"
color_empiricism = "orchid"
alpha_fill = 0.3

# Create the plot with an optimized style
plt.figure(figsize=(10, 6))
plt.fill_between(
    periods, existentialism_interest, color=color_existentialism, alpha=alpha_fill, label=fill_label_existentialism
)
plt.fill_between(
    periods, stoicism_interest, color=color_stoicism, alpha=alpha_fill, label=fill_label_stoicism
)
plt.fill_between(
    periods, rationalism_interest, color=color_rationalism, alpha=alpha_fill, label=fill_label_rationalism
)
plt.fill_between(
    periods, empiricism_interest, color=color_empiricism, alpha=alpha_fill, label=fill_label_empiricism
)
plt.plot(
    periods,
    benchmark_philosophy,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_52.pdf", bbox_inches="tight")
