
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the plot with agricultural metrics
months = np.array([1, 2, 3, 4, 5, 6])
avg_crop_yield = np.array([2.5, 2.7, 2.8, 2.9, 3.0, 3.1]) + np.random.uniform(-0.1, 0.1, 6)
fertilizer_usage = np.array([50, 55, 52, 58, 60, 65]) + np.random.uniform(-3, 3, 6)
irrigation = np.array([20, 25, 22, 28, 30, 32]) + np.random.uniform(-2, 2, 6)
temperature_variation = np.array([15, 16, 17, 18, 19, 20]) + np.random.uniform(-1, 1, 6)
benchmark_agriculture = np.linspace(2, 2, len(months))  # Benchmark line

# Extracted variables for labels
fill_label_avg_crop_yield = "Avg Crop Yield (tons/ha)"
fill_label_fertilizer_usage = "Fertilizer Usage (kg/ha)"
fill_label_irrigation = "Irrigation (inches)"
fill_label_temperature_variation = "Temp Variation (°C)"
plot_label_benchmark = "Benchmark"
title_text = "Agricultural Metrics Over 6 Months"
xlabel_text = "Months"
ylabel_text = "Measurements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim_values = (1, 6)
ylim_values = (10, 70)
xticks_values = months
yticks_values = [10, 20, 30, 40, 50, 60, 70]
legend_loc = "upper center"
legend_bbox_to_anchor = (0.5, 1.08)
legend_ncol = 5

# Create the plot with a geographical style
plt.figure(figsize=(10, 6))
plt.fill_between(
    months, avg_crop_yield, color="#2a9d8f", alpha=0.3, label=fill_label_avg_crop_yield
)
plt.fill_between(
    months, fertilizer_usage, color="#e9c46a", alpha=0.3, label=fill_label_fertilizer_usage
)
plt.fill_between(
    months, irrigation, color="#264653", alpha=0.3, label=fill_label_irrigation
)
plt.fill_between(
    months, temperature_variation, color="#f4a261", alpha=0.3, label=fill_label_temperature_variation
)
plt.plot(
    months,
    benchmark_agriculture,
    color="black",
    linestyle="--",
    linewidth=2,
    label=plot_label_benchmark,
)

# Add a title and labels with enhanced formatting
plt.title(title_text, fontsize=16, y=1.05)
plt.xlabel(xlabel_text, fontsize=14)
plt.ylabel(ylabel_text, fontsize=14)
plt.xticks(xticks_values, fontsize=12)
plt.yticks(yticks_values, fontsize=12)
plt.gca().tick_params(axis="both", which="both", length=0)

# Setting the limits explicitly to prevent cut-offs
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Adding a legend with a title
plt.legend(
    frameon=False,
    reverse=True,
    framealpha=0.8,
    loc=legend_loc,
    bbox_to_anchor=legend_bbox_to_anchor,
    ncol=legend_ncol,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no clipping
plt.tight_layout()
plt.savefig("area_53.pdf", bbox_inches="tight")
